/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentity.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cognitoidentity.model.CognitoIdentityProvider;

@SdkInternalApi
public class CognitoIdentityProviderMarshaller {
    private static final MarshallingInfo<String> PROVIDERNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProviderName").build();
    private static final MarshallingInfo<String> CLIENTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ClientId").build();
    private static final MarshallingInfo<Boolean> SERVERSIDETOKENCHECK_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ServerSideTokenCheck").build();
    private static final CognitoIdentityProviderMarshaller INSTANCE = new CognitoIdentityProviderMarshaller();

    public static CognitoIdentityProviderMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CognitoIdentityProvider cognitoIdentityProvider, ProtocolMarshaller protocolMarshaller) {
        if (cognitoIdentityProvider == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)cognitoIdentityProvider.providerName(), PROVIDERNAME_BINDING);
            protocolMarshaller.marshall((Object)cognitoIdentityProvider.clientId(), CLIENTID_BINDING);
            protocolMarshaller.marshall((Object)cognitoIdentityProvider.serverSideTokenCheck(), SERVERSIDETOKENCHECK_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

