/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentity.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.cognitoidentity.model.IdentityPoolShortDescription;
import software.amazon.awssdk.services.cognitoidentity.model.IdentityPoolsListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListIdentityPoolsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListIdentityPoolsResponse> {
    private final List<IdentityPoolShortDescription> identityPools;
    private final String nextToken;

    private ListIdentityPoolsResponse(BuilderImpl builder) {
        this.identityPools = builder.identityPools;
        this.nextToken = builder.nextToken;
    }

    public List<IdentityPoolShortDescription> identityPools() {
        return this.identityPools;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.identityPools() == null ? 0 : this.identityPools().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListIdentityPoolsResponse)) {
            return false;
        }
        ListIdentityPoolsResponse other = (ListIdentityPoolsResponse)((Object)obj);
        if (other.identityPools() == null ^ this.identityPools() == null) {
            return false;
        }
        if (other.identityPools() != null && !other.identityPools().equals(this.identityPools())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.identityPools() != null) {
            sb.append("IdentityPools: ").append(this.identityPools()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<IdentityPoolShortDescription> identityPools;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListIdentityPoolsResponse model) {
            this.setIdentityPools(model.identityPools);
            this.setNextToken(model.nextToken);
        }

        public final Collection<IdentityPoolShortDescription> getIdentityPools() {
            return this.identityPools;
        }

        @Override
        public final Builder identityPools(Collection<IdentityPoolShortDescription> identityPools) {
            this.identityPools = IdentityPoolsListCopier.copy(identityPools);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder identityPools(IdentityPoolShortDescription ... identityPools) {
            if (this.identityPools == null) {
                this.identityPools = new ArrayList<IdentityPoolShortDescription>(identityPools.length);
            }
            for (IdentityPoolShortDescription e : identityPools) {
                this.identityPools.add(e);
            }
            return this;
        }

        public final void setIdentityPools(Collection<IdentityPoolShortDescription> identityPools) {
            this.identityPools = IdentityPoolsListCopier.copy(identityPools);
        }

        @SafeVarargs
        public final void setIdentityPools(IdentityPoolShortDescription ... identityPools) {
            if (this.identityPools == null) {
                this.identityPools = new ArrayList<IdentityPoolShortDescription>(identityPools.length);
            }
            for (IdentityPoolShortDescription e : identityPools) {
                this.identityPools.add(e);
            }
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public ListIdentityPoolsResponse build() {
            return new ListIdentityPoolsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListIdentityPoolsResponse> {
        public Builder identityPools(Collection<IdentityPoolShortDescription> var1);

        public Builder identityPools(IdentityPoolShortDescription ... var1);

        public Builder nextToken(String var1);
    }
}

