/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentity.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.cognitoidentity.model.LoginsListCopier;
import software.amazon.awssdk.services.cognitoidentity.transform.IdentityDescriptionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class IdentityDescription
implements StructuredPojo,
ToCopyableBuilder<Builder, IdentityDescription> {
    private final String identityId;
    private final List<String> logins;
    private final Date creationDate;
    private final Date lastModifiedDate;

    private IdentityDescription(BuilderImpl builder) {
        this.identityId = builder.identityId;
        this.logins = builder.logins;
        this.creationDate = builder.creationDate;
        this.lastModifiedDate = builder.lastModifiedDate;
    }

    public String identityId() {
        return this.identityId;
    }

    public List<String> logins() {
        return this.logins;
    }

    public Date creationDate() {
        return this.creationDate;
    }

    public Date lastModifiedDate() {
        return this.lastModifiedDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.identityId() == null ? 0 : this.identityId().hashCode());
        hashCode = 31 * hashCode + (this.logins() == null ? 0 : this.logins().hashCode());
        hashCode = 31 * hashCode + (this.creationDate() == null ? 0 : this.creationDate().hashCode());
        hashCode = 31 * hashCode + (this.lastModifiedDate() == null ? 0 : this.lastModifiedDate().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IdentityDescription)) {
            return false;
        }
        IdentityDescription other = (IdentityDescription)obj;
        if (other.identityId() == null ^ this.identityId() == null) {
            return false;
        }
        if (other.identityId() != null && !other.identityId().equals(this.identityId())) {
            return false;
        }
        if (other.logins() == null ^ this.logins() == null) {
            return false;
        }
        if (other.logins() != null && !other.logins().equals(this.logins())) {
            return false;
        }
        if (other.creationDate() == null ^ this.creationDate() == null) {
            return false;
        }
        if (other.creationDate() != null && !other.creationDate().equals(this.creationDate())) {
            return false;
        }
        if (other.lastModifiedDate() == null ^ this.lastModifiedDate() == null) {
            return false;
        }
        return other.lastModifiedDate() == null || other.lastModifiedDate().equals(this.lastModifiedDate());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.identityId() != null) {
            sb.append("IdentityId: ").append(this.identityId()).append(",");
        }
        if (this.logins() != null) {
            sb.append("Logins: ").append(this.logins()).append(",");
        }
        if (this.creationDate() != null) {
            sb.append("CreationDate: ").append(this.creationDate()).append(",");
        }
        if (this.lastModifiedDate() != null) {
            sb.append("LastModifiedDate: ").append(this.lastModifiedDate()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        IdentityDescriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String identityId;
        private List<String> logins;
        private Date creationDate;
        private Date lastModifiedDate;

        private BuilderImpl() {
        }

        private BuilderImpl(IdentityDescription model) {
            this.setIdentityId(model.identityId);
            this.setLogins(model.logins);
            this.setCreationDate(model.creationDate);
            this.setLastModifiedDate(model.lastModifiedDate);
        }

        public final String getIdentityId() {
            return this.identityId;
        }

        @Override
        public final Builder identityId(String identityId) {
            this.identityId = identityId;
            return this;
        }

        public final void setIdentityId(String identityId) {
            this.identityId = identityId;
        }

        public final Collection<String> getLogins() {
            return this.logins;
        }

        @Override
        public final Builder logins(Collection<String> logins) {
            this.logins = LoginsListCopier.copy(logins);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logins(String ... logins) {
            if (this.logins == null) {
                this.logins = new ArrayList<String>(logins.length);
            }
            for (String e : logins) {
                this.logins.add(e);
            }
            return this;
        }

        public final void setLogins(Collection<String> logins) {
            this.logins = LoginsListCopier.copy(logins);
        }

        @SafeVarargs
        public final void setLogins(String ... logins) {
            if (this.logins == null) {
                this.logins = new ArrayList<String>(logins.length);
            }
            for (String e : logins) {
                this.logins.add(e);
            }
        }

        public final Date getCreationDate() {
            return this.creationDate;
        }

        @Override
        public final Builder creationDate(Date creationDate) {
            this.creationDate = StandardMemberCopier.copy((Date)creationDate);
            return this;
        }

        public final void setCreationDate(Date creationDate) {
            this.creationDate = StandardMemberCopier.copy((Date)creationDate);
        }

        public final Date getLastModifiedDate() {
            return this.lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(Date lastModifiedDate) {
            this.lastModifiedDate = StandardMemberCopier.copy((Date)lastModifiedDate);
            return this;
        }

        public final void setLastModifiedDate(Date lastModifiedDate) {
            this.lastModifiedDate = StandardMemberCopier.copy((Date)lastModifiedDate);
        }

        public IdentityDescription build() {
            return new IdentityDescription(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, IdentityDescription> {
        public Builder identityId(String var1);

        public Builder logins(Collection<String> var1);

        public Builder logins(String ... var1);

        public Builder creationDate(Date var1);

        public Builder lastModifiedDate(Date var1);
    }
}

