/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentity.model;

import java.util.Map;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.cognitoidentity.model.LoginsMapCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetIdRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, GetIdRequest> {
    private final String accountId;
    private final String identityPoolId;
    private final Map<String, String> logins;

    private GetIdRequest(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.identityPoolId = builder.identityPoolId;
        this.logins = builder.logins;
    }

    public String accountId() {
        return this.accountId;
    }

    public String identityPoolId() {
        return this.identityPoolId;
    }

    public Map<String, String> logins() {
        return this.logins;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.accountId() == null ? 0 : this.accountId().hashCode());
        hashCode = 31 * hashCode + (this.identityPoolId() == null ? 0 : this.identityPoolId().hashCode());
        hashCode = 31 * hashCode + (this.logins() == null ? 0 : this.logins().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetIdRequest)) {
            return false;
        }
        GetIdRequest other = (GetIdRequest)((Object)obj);
        if (other.accountId() == null ^ this.accountId() == null) {
            return false;
        }
        if (other.accountId() != null && !other.accountId().equals(this.accountId())) {
            return false;
        }
        if (other.identityPoolId() == null ^ this.identityPoolId() == null) {
            return false;
        }
        if (other.identityPoolId() != null && !other.identityPoolId().equals(this.identityPoolId())) {
            return false;
        }
        if (other.logins() == null ^ this.logins() == null) {
            return false;
        }
        return other.logins() == null || other.logins().equals(this.logins());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.accountId() != null) {
            sb.append("AccountId: ").append(this.accountId()).append(",");
        }
        if (this.identityPoolId() != null) {
            sb.append("IdentityPoolId: ").append(this.identityPoolId()).append(",");
        }
        if (this.logins() != null) {
            sb.append("Logins: ").append(this.logins()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String accountId;
        private String identityPoolId;
        private Map<String, String> logins;

        private BuilderImpl() {
        }

        private BuilderImpl(GetIdRequest model) {
            this.setAccountId(model.accountId);
            this.setIdentityPoolId(model.identityPoolId);
            this.setLogins(model.logins);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public final String getIdentityPoolId() {
            return this.identityPoolId;
        }

        @Override
        public final Builder identityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
            return this;
        }

        public final void setIdentityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
        }

        public final Map<String, String> getLogins() {
            return this.logins;
        }

        @Override
        public final Builder logins(Map<String, String> logins) {
            this.logins = LoginsMapCopier.copy(logins);
            return this;
        }

        public final void setLogins(Map<String, String> logins) {
            this.logins = LoginsMapCopier.copy(logins);
        }

        public GetIdRequest build() {
            return new GetIdRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetIdRequest> {
        public Builder accountId(String var1);

        public Builder identityPoolId(String var1);

        public Builder logins(Map<String, String> var1);
    }
}

