/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codestarnotifications;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.codestarnotifications.CodestarNotificationsClient;
import software.amazon.awssdk.services.codestarnotifications.CodestarNotificationsClientBuilder;
import software.amazon.awssdk.services.codestarnotifications.CodestarNotificationsServiceClientConfiguration;
import software.amazon.awssdk.services.codestarnotifications.DefaultCodestarNotificationsBaseClientBuilder;
import software.amazon.awssdk.services.codestarnotifications.DefaultCodestarNotificationsClient;
import software.amazon.awssdk.services.codestarnotifications.endpoints.CodestarNotificationsEndpointProvider;

@SdkInternalApi
final class DefaultCodestarNotificationsClientBuilder
extends DefaultCodestarNotificationsBaseClientBuilder<CodestarNotificationsClientBuilder, CodestarNotificationsClient>
implements CodestarNotificationsClientBuilder {
    DefaultCodestarNotificationsClientBuilder() {
    }

    @Override
    public DefaultCodestarNotificationsClientBuilder endpointProvider(CodestarNotificationsEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final CodestarNotificationsClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultCodestarNotificationsClientBuilder.validateClientOptions(clientConfiguration);
        CodestarNotificationsServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultCodestarNotificationsClient client = new DefaultCodestarNotificationsClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private CodestarNotificationsServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return CodestarNotificationsServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

