/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codestarconnections.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codestarconnections.model.CodeStarConnectionsRequest;
import software.amazon.awssdk.services.codestarconnections.model.SyncConfigurationType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateSyncBlockerRequest
extends CodeStarConnectionsRequest
implements ToCopyableBuilder<Builder, UpdateSyncBlockerRequest> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(UpdateSyncBlockerRequest.getter(UpdateSyncBlockerRequest::id)).setter(UpdateSyncBlockerRequest.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> SYNC_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SyncType").getter(UpdateSyncBlockerRequest.getter(UpdateSyncBlockerRequest::syncTypeAsString)).setter(UpdateSyncBlockerRequest.setter(Builder::syncType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SyncType").build()}).build();
    private static final SdkField<String> RESOURCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceName").getter(UpdateSyncBlockerRequest.getter(UpdateSyncBlockerRequest::resourceName)).setter(UpdateSyncBlockerRequest.setter(Builder::resourceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceName").build()}).build();
    private static final SdkField<String> RESOLVED_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResolvedReason").getter(UpdateSyncBlockerRequest.getter(UpdateSyncBlockerRequest::resolvedReason)).setter(UpdateSyncBlockerRequest.setter(Builder::resolvedReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResolvedReason").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, SYNC_TYPE_FIELD, RESOURCE_NAME_FIELD, RESOLVED_REASON_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateSyncBlockerRequest.memberNameToFieldInitializer();
    private final String id;
    private final String syncType;
    private final String resourceName;
    private final String resolvedReason;

    private UpdateSyncBlockerRequest(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.syncType = builder.syncType;
        this.resourceName = builder.resourceName;
        this.resolvedReason = builder.resolvedReason;
    }

    public final String id() {
        return this.id;
    }

    public final SyncConfigurationType syncType() {
        return SyncConfigurationType.fromValue(this.syncType);
    }

    public final String syncTypeAsString() {
        return this.syncType;
    }

    public final String resourceName() {
        return this.resourceName;
    }

    public final String resolvedReason() {
        return this.resolvedReason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.syncTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.resolvedReason());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSyncBlockerRequest)) {
            return false;
        }
        UpdateSyncBlockerRequest other = (UpdateSyncBlockerRequest)((Object)obj);
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.syncTypeAsString(), other.syncTypeAsString()) && Objects.equals(this.resourceName(), other.resourceName()) && Objects.equals(this.resolvedReason(), other.resolvedReason());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateSyncBlockerRequest").add("Id", (Object)this.id()).add("SyncType", (Object)this.syncTypeAsString()).add("ResourceName", (Object)this.resourceName()).add("ResolvedReason", (Object)this.resolvedReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "SyncType": {
                return Optional.ofNullable(clazz.cast(this.syncTypeAsString()));
            }
            case "ResourceName": {
                return Optional.ofNullable(clazz.cast(this.resourceName()));
            }
            case "ResolvedReason": {
                return Optional.ofNullable(clazz.cast(this.resolvedReason()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("Id", ID_FIELD);
        map.put("SyncType", SYNC_TYPE_FIELD);
        map.put("ResourceName", RESOURCE_NAME_FIELD);
        map.put("ResolvedReason", RESOLVED_REASON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateSyncBlockerRequest, T> g) {
        return obj -> g.apply((UpdateSyncBlockerRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeStarConnectionsRequest.BuilderImpl
    implements Builder {
        private String id;
        private String syncType;
        private String resourceName;
        private String resolvedReason;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSyncBlockerRequest model) {
            super(model);
            this.id(model.id);
            this.syncType(model.syncType);
            this.resourceName(model.resourceName);
            this.resolvedReason(model.resolvedReason);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getSyncType() {
            return this.syncType;
        }

        public final void setSyncType(String syncType) {
            this.syncType = syncType;
        }

        @Override
        public final Builder syncType(String syncType) {
            this.syncType = syncType;
            return this;
        }

        @Override
        public final Builder syncType(SyncConfigurationType syncType) {
            this.syncType(syncType == null ? null : syncType.toString());
            return this;
        }

        public final String getResourceName() {
            return this.resourceName;
        }

        public final void setResourceName(String resourceName) {
            this.resourceName = resourceName;
        }

        @Override
        public final Builder resourceName(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        public final String getResolvedReason() {
            return this.resolvedReason;
        }

        public final void setResolvedReason(String resolvedReason) {
            this.resolvedReason = resolvedReason;
        }

        @Override
        public final Builder resolvedReason(String resolvedReason) {
            this.resolvedReason = resolvedReason;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateSyncBlockerRequest build() {
            return new UpdateSyncBlockerRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CodeStarConnectionsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateSyncBlockerRequest> {
        public Builder id(String var1);

        public Builder syncType(String var1);

        public Builder syncType(SyncConfigurationType var1);

        public Builder resourceName(String var1);

        public Builder resolvedReason(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

