/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codestarconnections.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateConnectionRequest extends CodeStarConnectionsRequest implements
        ToCopyableBuilder<CreateConnectionRequest.Builder, CreateConnectionRequest> {
    private static final SdkField<String> PROVIDER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateConnectionRequest::providerTypeAsString)).setter(setter(Builder::providerType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProviderType").build()).build();

    private static final SdkField<String> CONNECTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateConnectionRequest::connectionName)).setter(setter(Builder::connectionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionName").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .getter(getter(CreateConnectionRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROVIDER_TYPE_FIELD,
            CONNECTION_NAME_FIELD, TAGS_FIELD));

    private final String providerType;

    private final String connectionName;

    private final List<Tag> tags;

    private CreateConnectionRequest(BuilderImpl builder) {
        super(builder);
        this.providerType = builder.providerType;
        this.connectionName = builder.connectionName;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name of the external provider where your third-party code repository is configured. Currently, the valid
     * provider type is Bitbucket.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #providerType} will
     * return {@link ProviderType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #providerTypeAsString}.
     * </p>
     * 
     * @return The name of the external provider where your third-party code repository is configured. Currently, the
     *         valid provider type is Bitbucket.
     * @see ProviderType
     */
    public ProviderType providerType() {
        return ProviderType.fromValue(providerType);
    }

    /**
     * <p>
     * The name of the external provider where your third-party code repository is configured. Currently, the valid
     * provider type is Bitbucket.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #providerType} will
     * return {@link ProviderType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #providerTypeAsString}.
     * </p>
     * 
     * @return The name of the external provider where your third-party code repository is configured. Currently, the
     *         valid provider type is Bitbucket.
     * @see ProviderType
     */
    public String providerTypeAsString() {
        return providerType;
    }

    /**
     * <p>
     * The name of the connection to be created. The name must be unique in the calling AWS account.
     * </p>
     * 
     * @return The name of the connection to be created. The name must be unique in the calling AWS account.
     */
    public String connectionName() {
        return connectionName;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The key-value pair to use when tagging the resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The key-value pair to use when tagging the resource.
     */
    public List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(providerTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(connectionName());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateConnectionRequest)) {
            return false;
        }
        CreateConnectionRequest other = (CreateConnectionRequest) obj;
        return Objects.equals(providerTypeAsString(), other.providerTypeAsString())
                && Objects.equals(connectionName(), other.connectionName()) && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateConnectionRequest").add("ProviderType", providerTypeAsString())
                .add("ConnectionName", connectionName()).add("Tags", tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProviderType":
            return Optional.ofNullable(clazz.cast(providerTypeAsString()));
        case "ConnectionName":
            return Optional.ofNullable(clazz.cast(connectionName()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateConnectionRequest, T> g) {
        return obj -> g.apply((CreateConnectionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeStarConnectionsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateConnectionRequest> {
        /**
         * <p>
         * The name of the external provider where your third-party code repository is configured. Currently, the valid
         * provider type is Bitbucket.
         * </p>
         * 
         * @param providerType
         *        The name of the external provider where your third-party code repository is configured. Currently, the
         *        valid provider type is Bitbucket.
         * @see ProviderType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProviderType
         */
        Builder providerType(String providerType);

        /**
         * <p>
         * The name of the external provider where your third-party code repository is configured. Currently, the valid
         * provider type is Bitbucket.
         * </p>
         * 
         * @param providerType
         *        The name of the external provider where your third-party code repository is configured. Currently, the
         *        valid provider type is Bitbucket.
         * @see ProviderType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProviderType
         */
        Builder providerType(ProviderType providerType);

        /**
         * <p>
         * The name of the connection to be created. The name must be unique in the calling AWS account.
         * </p>
         * 
         * @param connectionName
         *        The name of the connection to be created. The name must be unique in the calling AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionName(String connectionName);

        /**
         * <p>
         * The key-value pair to use when tagging the resource.
         * </p>
         * 
         * @param tags
         *        The key-value pair to use when tagging the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The key-value pair to use when tagging the resource.
         * </p>
         * 
         * @param tags
         *        The key-value pair to use when tagging the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The key-value pair to use when tagging the resource.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodeStarConnectionsRequest.BuilderImpl implements Builder {
        private String providerType;

        private String connectionName;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateConnectionRequest model) {
            super(model);
            providerType(model.providerType);
            connectionName(model.connectionName);
            tags(model.tags);
        }

        public final String getProviderType() {
            return providerType;
        }

        @Override
        public final Builder providerType(String providerType) {
            this.providerType = providerType;
            return this;
        }

        @Override
        public final Builder providerType(ProviderType providerType) {
            this.providerType(providerType == null ? null : providerType.toString());
            return this;
        }

        public final void setProviderType(String providerType) {
            this.providerType = providerType;
        }

        public final String getConnectionName() {
            return connectionName;
        }

        @Override
        public final Builder connectionName(String connectionName) {
            this.connectionName = connectionName;
            return this;
        }

        public final void setConnectionName(String connectionName) {
            this.connectionName = connectionName;
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateConnectionRequest build() {
            return new CreateConnectionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
