/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codestar.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a team member in a project.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TeamMember implements SdkPojo, Serializable, ToCopyableBuilder<TeamMember.Builder, TeamMember> {
    private static final SdkField<String> USER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TeamMember::userArn)).setter(setter(Builder::userArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userArn").build()).build();

    private static final SdkField<String> PROJECT_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TeamMember::projectRole)).setter(setter(Builder::projectRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectRole").build()).build();

    private static final SdkField<Boolean> REMOTE_ACCESS_ALLOWED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(TeamMember::remoteAccessAllowed)).setter(setter(Builder::remoteAccessAllowed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("remoteAccessAllowed").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_ARN_FIELD,
            PROJECT_ROLE_FIELD, REMOTE_ACCESS_ALLOWED_FIELD));

    private static final long serialVersionUID = 1L;

    private final String userArn;

    private final String projectRole;

    private final Boolean remoteAccessAllowed;

    private TeamMember(BuilderImpl builder) {
        this.userArn = builder.userArn;
        this.projectRole = builder.projectRole;
        this.remoteAccessAllowed = builder.remoteAccessAllowed;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the user in IAM.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the user in IAM.
     */
    public String userArn() {
        return userArn;
    }

    /**
     * <p>
     * The role assigned to the user in the project. Project roles have different levels of access. For more
     * information, see <a href="http://docs.aws.amazon.com/codestar/latest/userguide/working-with-teams.html">Working
     * with Teams</a> in the <i>AWS CodeStar User Guide</i>.
     * </p>
     * 
     * @return The role assigned to the user in the project. Project roles have different levels of access. For more
     *         information, see <a
     *         href="http://docs.aws.amazon.com/codestar/latest/userguide/working-with-teams.html">Working with
     *         Teams</a> in the <i>AWS CodeStar User Guide</i>.
     */
    public String projectRole() {
        return projectRole;
    }

    /**
     * <p>
     * Whether the user is allowed to remotely access project resources using an SSH public/private key pair.
     * </p>
     * 
     * @return Whether the user is allowed to remotely access project resources using an SSH public/private key pair.
     */
    public Boolean remoteAccessAllowed() {
        return remoteAccessAllowed;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(userArn());
        hashCode = 31 * hashCode + Objects.hashCode(projectRole());
        hashCode = 31 * hashCode + Objects.hashCode(remoteAccessAllowed());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TeamMember)) {
            return false;
        }
        TeamMember other = (TeamMember) obj;
        return Objects.equals(userArn(), other.userArn()) && Objects.equals(projectRole(), other.projectRole())
                && Objects.equals(remoteAccessAllowed(), other.remoteAccessAllowed());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("TeamMember").add("UserArn", userArn()).add("ProjectRole", projectRole())
                .add("RemoteAccessAllowed", remoteAccessAllowed()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "userArn":
            return Optional.ofNullable(clazz.cast(userArn()));
        case "projectRole":
            return Optional.ofNullable(clazz.cast(projectRole()));
        case "remoteAccessAllowed":
            return Optional.ofNullable(clazz.cast(remoteAccessAllowed()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TeamMember, T> g) {
        return obj -> g.apply((TeamMember) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TeamMember> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the user in IAM.
         * </p>
         * 
         * @param userArn
         *        The Amazon Resource Name (ARN) of the user in IAM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userArn(String userArn);

        /**
         * <p>
         * The role assigned to the user in the project. Project roles have different levels of access. For more
         * information, see <a
         * href="http://docs.aws.amazon.com/codestar/latest/userguide/working-with-teams.html">Working with Teams</a> in
         * the <i>AWS CodeStar User Guide</i>.
         * </p>
         * 
         * @param projectRole
         *        The role assigned to the user in the project. Project roles have different levels of access. For more
         *        information, see <a
         *        href="http://docs.aws.amazon.com/codestar/latest/userguide/working-with-teams.html">Working with
         *        Teams</a> in the <i>AWS CodeStar User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectRole(String projectRole);

        /**
         * <p>
         * Whether the user is allowed to remotely access project resources using an SSH public/private key pair.
         * </p>
         * 
         * @param remoteAccessAllowed
         *        Whether the user is allowed to remotely access project resources using an SSH public/private key pair.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remoteAccessAllowed(Boolean remoteAccessAllowed);
    }

    static final class BuilderImpl implements Builder {
        private String userArn;

        private String projectRole;

        private Boolean remoteAccessAllowed;

        private BuilderImpl() {
        }

        private BuilderImpl(TeamMember model) {
            userArn(model.userArn);
            projectRole(model.projectRole);
            remoteAccessAllowed(model.remoteAccessAllowed);
        }

        public final String getUserArn() {
            return userArn;
        }

        @Override
        public final Builder userArn(String userArn) {
            this.userArn = userArn;
            return this;
        }

        public final void setUserArn(String userArn) {
            this.userArn = userArn;
        }

        public final String getProjectRole() {
            return projectRole;
        }

        @Override
        public final Builder projectRole(String projectRole) {
            this.projectRole = projectRole;
            return this;
        }

        public final void setProjectRole(String projectRole) {
            this.projectRole = projectRole;
        }

        public final Boolean getRemoteAccessAllowed() {
            return remoteAccessAllowed;
        }

        @Override
        public final Builder remoteAccessAllowed(Boolean remoteAccessAllowed) {
            this.remoteAccessAllowed = remoteAccessAllowed;
            return this;
        }

        public final void setRemoteAccessAllowed(Boolean remoteAccessAllowed) {
            this.remoteAccessAllowed = remoteAccessAllowed;
        }

        @Override
        public TeamMember build() {
            return new TeamMember(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
