/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codestar.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListUserProfilesResponse extends CodeStarResponse implements
        ToCopyableBuilder<ListUserProfilesResponse.Builder, ListUserProfilesResponse> {
    private static final SdkField<List<UserProfileSummary>> USER_PROFILES_FIELD = SdkField
            .<List<UserProfileSummary>> builder(MarshallingType.LIST)
            .getter(getter(ListUserProfilesResponse::userProfiles))
            .setter(setter(Builder::userProfiles))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userProfiles").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UserProfileSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(UserProfileSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListUserProfilesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_PROFILES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<UserProfileSummary> userProfiles;

    private final String nextToken;

    private ListUserProfilesResponse(BuilderImpl builder) {
        super(builder);
        this.userProfiles = builder.userProfiles;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the UserProfiles property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasUserProfiles() {
        return userProfiles != null && !(userProfiles instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * All the user profiles configured in AWS CodeStar for an AWS account.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasUserProfiles()} to see if a value was sent in this field.
     * </p>
     * 
     * @return All the user profiles configured in AWS CodeStar for an AWS account.
     */
    public List<UserProfileSummary> userProfiles() {
        return userProfiles;
    }

    /**
     * <p>
     * The continuation token to use when requesting the next set of results, if there are more results to be returned.
     * </p>
     * 
     * @return The continuation token to use when requesting the next set of results, if there are more results to be
     *         returned.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(userProfiles());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListUserProfilesResponse)) {
            return false;
        }
        ListUserProfilesResponse other = (ListUserProfilesResponse) obj;
        return Objects.equals(userProfiles(), other.userProfiles()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListUserProfilesResponse").add("UserProfiles", userProfiles()).add("NextToken", nextToken())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "userProfiles":
            return Optional.ofNullable(clazz.cast(userProfiles()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListUserProfilesResponse, T> g) {
        return obj -> g.apply((ListUserProfilesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeStarResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListUserProfilesResponse> {
        /**
         * <p>
         * All the user profiles configured in AWS CodeStar for an AWS account.
         * </p>
         * 
         * @param userProfiles
         *        All the user profiles configured in AWS CodeStar for an AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userProfiles(Collection<UserProfileSummary> userProfiles);

        /**
         * <p>
         * All the user profiles configured in AWS CodeStar for an AWS account.
         * </p>
         * 
         * @param userProfiles
         *        All the user profiles configured in AWS CodeStar for an AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userProfiles(UserProfileSummary... userProfiles);

        /**
         * <p>
         * All the user profiles configured in AWS CodeStar for an AWS account.
         * </p>
         * This is a convenience that creates an instance of the {@link List<UserProfileSummary>.Builder} avoiding the
         * need to create one manually via {@link List<UserProfileSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<UserProfileSummary>.Builder#build()} is called immediately
         * and its result is passed to {@link #userProfiles(List<UserProfileSummary>)}.
         * 
         * @param userProfiles
         *        a consumer that will call methods on {@link List<UserProfileSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userProfiles(List<UserProfileSummary>)
         */
        Builder userProfiles(Consumer<UserProfileSummary.Builder>... userProfiles);

        /**
         * <p>
         * The continuation token to use when requesting the next set of results, if there are more results to be
         * returned.
         * </p>
         * 
         * @param nextToken
         *        The continuation token to use when requesting the next set of results, if there are more results to be
         *        returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends CodeStarResponse.BuilderImpl implements Builder {
        private List<UserProfileSummary> userProfiles = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListUserProfilesResponse model) {
            super(model);
            userProfiles(model.userProfiles);
            nextToken(model.nextToken);
        }

        public final Collection<UserProfileSummary.Builder> getUserProfiles() {
            return userProfiles != null ? userProfiles.stream().map(UserProfileSummary::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder userProfiles(Collection<UserProfileSummary> userProfiles) {
            this.userProfiles = UserProfilesListCopier.copy(userProfiles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userProfiles(UserProfileSummary... userProfiles) {
            userProfiles(Arrays.asList(userProfiles));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userProfiles(Consumer<UserProfileSummary.Builder>... userProfiles) {
            userProfiles(Stream.of(userProfiles).map(c -> UserProfileSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setUserProfiles(Collection<UserProfileSummary.BuilderImpl> userProfiles) {
            this.userProfiles = UserProfilesListCopier.copyFromBuilder(userProfiles);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListUserProfilesResponse build() {
            return new ListUserProfilesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
