/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codestar.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTeamMembersResponse extends CodeStarResponse implements
        ToCopyableBuilder<ListTeamMembersResponse.Builder, ListTeamMembersResponse> {
    private static final SdkField<List<TeamMember>> TEAM_MEMBERS_FIELD = SdkField
            .<List<TeamMember>> builder(MarshallingType.LIST)
            .getter(getter(ListTeamMembersResponse::teamMembers))
            .setter(setter(Builder::teamMembers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("teamMembers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TeamMember> builder(MarshallingType.SDK_POJO)
                                            .constructor(TeamMember::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListTeamMembersResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEAM_MEMBERS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<TeamMember> teamMembers;

    private final String nextToken;

    private ListTeamMembersResponse(BuilderImpl builder) {
        super(builder);
        this.teamMembers = builder.teamMembers;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the TeamMembers property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTeamMembers() {
        return teamMembers != null && !(teamMembers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of team member objects for the project.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTeamMembers()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of team member objects for the project.
     */
    public List<TeamMember> teamMembers() {
        return teamMembers;
    }

    /**
     * <p>
     * The continuation token to use when requesting the next set of results, if there are more results to be returned.
     * </p>
     * 
     * @return The continuation token to use when requesting the next set of results, if there are more results to be
     *         returned.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(teamMembers());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTeamMembersResponse)) {
            return false;
        }
        ListTeamMembersResponse other = (ListTeamMembersResponse) obj;
        return Objects.equals(teamMembers(), other.teamMembers()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListTeamMembersResponse").add("TeamMembers", teamMembers()).add("NextToken", nextToken())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "teamMembers":
            return Optional.ofNullable(clazz.cast(teamMembers()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTeamMembersResponse, T> g) {
        return obj -> g.apply((ListTeamMembersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeStarResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListTeamMembersResponse> {
        /**
         * <p>
         * A list of team member objects for the project.
         * </p>
         * 
         * @param teamMembers
         *        A list of team member objects for the project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder teamMembers(Collection<TeamMember> teamMembers);

        /**
         * <p>
         * A list of team member objects for the project.
         * </p>
         * 
         * @param teamMembers
         *        A list of team member objects for the project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder teamMembers(TeamMember... teamMembers);

        /**
         * <p>
         * A list of team member objects for the project.
         * </p>
         * This is a convenience that creates an instance of the {@link List<TeamMember>.Builder} avoiding the need to
         * create one manually via {@link List<TeamMember>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TeamMember>.Builder#build()} is called immediately and its
         * result is passed to {@link #teamMembers(List<TeamMember>)}.
         * 
         * @param teamMembers
         *        a consumer that will call methods on {@link List<TeamMember>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #teamMembers(List<TeamMember>)
         */
        Builder teamMembers(Consumer<TeamMember.Builder>... teamMembers);

        /**
         * <p>
         * The continuation token to use when requesting the next set of results, if there are more results to be
         * returned.
         * </p>
         * 
         * @param nextToken
         *        The continuation token to use when requesting the next set of results, if there are more results to be
         *        returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends CodeStarResponse.BuilderImpl implements Builder {
        private List<TeamMember> teamMembers = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTeamMembersResponse model) {
            super(model);
            teamMembers(model.teamMembers);
            nextToken(model.nextToken);
        }

        public final Collection<TeamMember.Builder> getTeamMembers() {
            return teamMembers != null ? teamMembers.stream().map(TeamMember::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder teamMembers(Collection<TeamMember> teamMembers) {
            this.teamMembers = TeamMemberResultCopier.copy(teamMembers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder teamMembers(TeamMember... teamMembers) {
            teamMembers(Arrays.asList(teamMembers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder teamMembers(Consumer<TeamMember.Builder>... teamMembers) {
            teamMembers(Stream.of(teamMembers).map(c -> TeamMember.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setTeamMembers(Collection<TeamMember.BuilderImpl> teamMembers) {
            this.teamMembers = TeamMemberResultCopier.copyFromBuilder(teamMembers);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListTeamMembersResponse build() {
            return new ListTeamMembersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
