/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codestar.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeUserProfileResponse extends CodeStarResponse implements
        ToCopyableBuilder<DescribeUserProfileResponse.Builder, DescribeUserProfileResponse> {
    private static final SdkField<String> USER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeUserProfileResponse::userArn)).setter(setter(Builder::userArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userArn").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeUserProfileResponse::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()).build();

    private static final SdkField<String> EMAIL_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeUserProfileResponse::emailAddress)).setter(setter(Builder::emailAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("emailAddress").build()).build();

    private static final SdkField<String> SSH_PUBLIC_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeUserProfileResponse::sshPublicKey)).setter(setter(Builder::sshPublicKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sshPublicKey").build()).build();

    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(DescribeUserProfileResponse::createdTimestamp)).setter(setter(Builder::createdTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdTimestamp").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(DescribeUserProfileResponse::lastModifiedTimestamp)).setter(setter(Builder::lastModifiedTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedTimestamp").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(USER_ARN_FIELD, DISPLAY_NAME_FIELD, EMAIL_ADDRESS_FIELD, SSH_PUBLIC_KEY_FIELD, CREATED_TIMESTAMP_FIELD,
                    LAST_MODIFIED_TIMESTAMP_FIELD));

    private final String userArn;

    private final String displayName;

    private final String emailAddress;

    private final String sshPublicKey;

    private final Instant createdTimestamp;

    private final Instant lastModifiedTimestamp;

    private DescribeUserProfileResponse(BuilderImpl builder) {
        super(builder);
        this.userArn = builder.userArn;
        this.displayName = builder.displayName;
        this.emailAddress = builder.emailAddress;
        this.sshPublicKey = builder.sshPublicKey;
        this.createdTimestamp = builder.createdTimestamp;
        this.lastModifiedTimestamp = builder.lastModifiedTimestamp;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the user.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the user.
     */
    public String userArn() {
        return userArn;
    }

    /**
     * <p>
     * The display name shown for the user in AWS CodeStar projects. For example, this could be set to both first and
     * last name ("Mary Major") or a single name ("Mary"). The display name is also used to generate the initial icon
     * associated with the user in AWS CodeStar projects. If spaces are included in the display name, the first
     * character that appears after the space will be used as the second character in the user initial icon. The initial
     * icon displays a maximum of two characters, so a display name with more than one space (for example
     * "Mary Jane Major") would generate an initial icon using the first character and the first character after the
     * space ("MJ", not "MM").
     * </p>
     * 
     * @return The display name shown for the user in AWS CodeStar projects. For example, this could be set to both
     *         first and last name ("Mary Major") or a single name ("Mary"). The display name is also used to generate
     *         the initial icon associated with the user in AWS CodeStar projects. If spaces are included in the display
     *         name, the first character that appears after the space will be used as the second character in the user
     *         initial icon. The initial icon displays a maximum of two characters, so a display name with more than one
     *         space (for example "Mary Jane Major") would generate an initial icon using the first character and the
     *         first character after the space ("MJ", not "MM").
     */
    public String displayName() {
        return displayName;
    }

    /**
     * <p>
     * The email address for the user. Optional.
     * </p>
     * 
     * @return The email address for the user. Optional.
     */
    public String emailAddress() {
        return emailAddress;
    }

    /**
     * <p>
     * The SSH public key associated with the user. This SSH public key is associated with the user profile, and can be
     * used in conjunction with the associated private key for access to project resources, such as Amazon EC2
     * instances, if a project owner grants remote access to those resources.
     * </p>
     * 
     * @return The SSH public key associated with the user. This SSH public key is associated with the user profile, and
     *         can be used in conjunction with the associated private key for access to project resources, such as
     *         Amazon EC2 instances, if a project owner grants remote access to those resources.
     */
    public String sshPublicKey() {
        return sshPublicKey;
    }

    /**
     * <p>
     * The date and time when the user profile was created in AWS CodeStar, in timestamp format.
     * </p>
     * 
     * @return The date and time when the user profile was created in AWS CodeStar, in timestamp format.
     */
    public Instant createdTimestamp() {
        return createdTimestamp;
    }

    /**
     * <p>
     * The date and time when the user profile was last modified, in timestamp format.
     * </p>
     * 
     * @return The date and time when the user profile was last modified, in timestamp format.
     */
    public Instant lastModifiedTimestamp() {
        return lastModifiedTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(userArn());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(emailAddress());
        hashCode = 31 * hashCode + Objects.hashCode(sshPublicKey());
        hashCode = 31 * hashCode + Objects.hashCode(createdTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTimestamp());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeUserProfileResponse)) {
            return false;
        }
        DescribeUserProfileResponse other = (DescribeUserProfileResponse) obj;
        return Objects.equals(userArn(), other.userArn()) && Objects.equals(displayName(), other.displayName())
                && Objects.equals(emailAddress(), other.emailAddress()) && Objects.equals(sshPublicKey(), other.sshPublicKey())
                && Objects.equals(createdTimestamp(), other.createdTimestamp())
                && Objects.equals(lastModifiedTimestamp(), other.lastModifiedTimestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeUserProfileResponse").add("UserArn", userArn())
                .add("DisplayName", displayName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("EmailAddress", emailAddress() == null ? null : "*** Sensitive Data Redacted ***")
                .add("SshPublicKey", sshPublicKey()).add("CreatedTimestamp", createdTimestamp())
                .add("LastModifiedTimestamp", lastModifiedTimestamp()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "userArn":
            return Optional.ofNullable(clazz.cast(userArn()));
        case "displayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "emailAddress":
            return Optional.ofNullable(clazz.cast(emailAddress()));
        case "sshPublicKey":
            return Optional.ofNullable(clazz.cast(sshPublicKey()));
        case "createdTimestamp":
            return Optional.ofNullable(clazz.cast(createdTimestamp()));
        case "lastModifiedTimestamp":
            return Optional.ofNullable(clazz.cast(lastModifiedTimestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeUserProfileResponse, T> g) {
        return obj -> g.apply((DescribeUserProfileResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeStarResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeUserProfileResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the user.
         * </p>
         * 
         * @param userArn
         *        The Amazon Resource Name (ARN) of the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userArn(String userArn);

        /**
         * <p>
         * The display name shown for the user in AWS CodeStar projects. For example, this could be set to both first
         * and last name ("Mary Major") or a single name ("Mary"). The display name is also used to generate the initial
         * icon associated with the user in AWS CodeStar projects. If spaces are included in the display name, the first
         * character that appears after the space will be used as the second character in the user initial icon. The
         * initial icon displays a maximum of two characters, so a display name with more than one space (for example
         * "Mary Jane Major") would generate an initial icon using the first character and the first character after the
         * space ("MJ", not "MM").
         * </p>
         * 
         * @param displayName
         *        The display name shown for the user in AWS CodeStar projects. For example, this could be set to both
         *        first and last name ("Mary Major") or a single name ("Mary"). The display name is also used to
         *        generate the initial icon associated with the user in AWS CodeStar projects. If spaces are included in
         *        the display name, the first character that appears after the space will be used as the second
         *        character in the user initial icon. The initial icon displays a maximum of two characters, so a
         *        display name with more than one space (for example "Mary Jane Major") would generate an initial icon
         *        using the first character and the first character after the space ("MJ", not "MM").
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The email address for the user. Optional.
         * </p>
         * 
         * @param emailAddress
         *        The email address for the user. Optional.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emailAddress(String emailAddress);

        /**
         * <p>
         * The SSH public key associated with the user. This SSH public key is associated with the user profile, and can
         * be used in conjunction with the associated private key for access to project resources, such as Amazon EC2
         * instances, if a project owner grants remote access to those resources.
         * </p>
         * 
         * @param sshPublicKey
         *        The SSH public key associated with the user. This SSH public key is associated with the user profile,
         *        and can be used in conjunction with the associated private key for access to project resources, such
         *        as Amazon EC2 instances, if a project owner grants remote access to those resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sshPublicKey(String sshPublicKey);

        /**
         * <p>
         * The date and time when the user profile was created in AWS CodeStar, in timestamp format.
         * </p>
         * 
         * @param createdTimestamp
         *        The date and time when the user profile was created in AWS CodeStar, in timestamp format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTimestamp(Instant createdTimestamp);

        /**
         * <p>
         * The date and time when the user profile was last modified, in timestamp format.
         * </p>
         * 
         * @param lastModifiedTimestamp
         *        The date and time when the user profile was last modified, in timestamp format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTimestamp(Instant lastModifiedTimestamp);
    }

    static final class BuilderImpl extends CodeStarResponse.BuilderImpl implements Builder {
        private String userArn;

        private String displayName;

        private String emailAddress;

        private String sshPublicKey;

        private Instant createdTimestamp;

        private Instant lastModifiedTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeUserProfileResponse model) {
            super(model);
            userArn(model.userArn);
            displayName(model.displayName);
            emailAddress(model.emailAddress);
            sshPublicKey(model.sshPublicKey);
            createdTimestamp(model.createdTimestamp);
            lastModifiedTimestamp(model.lastModifiedTimestamp);
        }

        public final String getUserArn() {
            return userArn;
        }

        @Override
        public final Builder userArn(String userArn) {
            this.userArn = userArn;
            return this;
        }

        public final void setUserArn(String userArn) {
            this.userArn = userArn;
        }

        public final String getDisplayName() {
            return displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public final String getEmailAddress() {
            return emailAddress;
        }

        @Override
        public final Builder emailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }

        public final void setEmailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
        }

        public final String getSshPublicKey() {
            return sshPublicKey;
        }

        @Override
        public final Builder sshPublicKey(String sshPublicKey) {
            this.sshPublicKey = sshPublicKey;
            return this;
        }

        public final void setSshPublicKey(String sshPublicKey) {
            this.sshPublicKey = sshPublicKey;
        }

        public final Instant getCreatedTimestamp() {
            return createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        public final Instant getLastModifiedTimestamp() {
            return lastModifiedTimestamp;
        }

        @Override
        public final Builder lastModifiedTimestamp(Instant lastModifiedTimestamp) {
            this.lastModifiedTimestamp = lastModifiedTimestamp;
            return this;
        }

        public final void setLastModifiedTimestamp(Instant lastModifiedTimestamp) {
            this.lastModifiedTimestamp = lastModifiedTimestamp;
        }

        @Override
        public DescribeUserProfileResponse build() {
            return new DescribeUserProfileResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
