/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.codepipeline.model.CodePipelineResponse;
import software.amazon.awssdk.services.codepipeline.model.ListWebhookItem;
import software.amazon.awssdk.services.codepipeline.model.WebhookListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListWebhooksResponse
extends CodePipelineResponse
implements ToCopyableBuilder<Builder, ListWebhooksResponse> {
    private static final SdkField<List<ListWebhookItem>> WEBHOOKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListWebhooksResponse.getter(ListWebhooksResponse::webhooks)).setter(ListWebhooksResponse.setter(Builder::webhooks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("webhooks").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ListWebhookItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListWebhooksResponse.getter(ListWebhooksResponse::nextToken)).setter(ListWebhooksResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WEBHOOKS_FIELD, NEXT_TOKEN_FIELD));
    private final List<ListWebhookItem> webhooks;
    private final String nextToken;

    private ListWebhooksResponse(BuilderImpl builder) {
        super(builder);
        this.webhooks = builder.webhooks;
        this.nextToken = builder.nextToken;
    }

    public List<ListWebhookItem> webhooks() {
        return this.webhooks;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.webhooks());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListWebhooksResponse)) {
            return false;
        }
        ListWebhooksResponse other = (ListWebhooksResponse)((Object)obj);
        return Objects.equals(this.webhooks(), other.webhooks()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListWebhooksResponse").add("Webhooks", this.webhooks()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "webhooks": {
                return Optional.ofNullable(clazz.cast(this.webhooks()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListWebhooksResponse, T> g) {
        return obj -> g.apply((ListWebhooksResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodePipelineResponse.BuilderImpl
    implements Builder {
        private List<ListWebhookItem> webhooks = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListWebhooksResponse model) {
            super(model);
            this.webhooks(model.webhooks);
            this.nextToken(model.nextToken);
        }

        public final Collection<ListWebhookItem.Builder> getWebhooks() {
            return this.webhooks != null ? (Collection)this.webhooks.stream().map(ListWebhookItem::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder webhooks(Collection<ListWebhookItem> webhooks) {
            this.webhooks = WebhookListCopier.copy(webhooks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder webhooks(ListWebhookItem ... webhooks) {
            this.webhooks(Arrays.asList(webhooks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder webhooks(Consumer<ListWebhookItem.Builder> ... webhooks) {
            this.webhooks(Stream.of(webhooks).map(c -> (ListWebhookItem)((ListWebhookItem.Builder)ListWebhookItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setWebhooks(Collection<ListWebhookItem.BuilderImpl> webhooks) {
            this.webhooks = WebhookListCopier.copyFromBuilder(webhooks);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListWebhooksResponse build() {
            return new ListWebhooksResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodePipelineResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListWebhooksResponse> {
        public Builder webhooks(Collection<ListWebhookItem> var1);

        public Builder webhooks(ListWebhookItem ... var1);

        public Builder webhooks(Consumer<ListWebhookItem.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

