/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codepipeline.model.ArtifactLocationType;
import software.amazon.awssdk.services.codepipeline.model.S3ArtifactLocation;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ArtifactLocation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ArtifactLocation> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ArtifactLocation.getter(ArtifactLocation::typeAsString)).setter(ArtifactLocation.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<S3ArtifactLocation> S3_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ArtifactLocation.getter(ArtifactLocation::s3Location)).setter(ArtifactLocation.setter(Builder::s3Location)).constructor(S3ArtifactLocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Location").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, S3_LOCATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String type;
    private final S3ArtifactLocation s3Location;

    private ArtifactLocation(BuilderImpl builder) {
        this.type = builder.type;
        this.s3Location = builder.s3Location;
    }

    public ArtifactLocationType type() {
        return ArtifactLocationType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public S3ArtifactLocation s3Location() {
        return this.s3Location;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Location());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ArtifactLocation)) {
            return false;
        }
        ArtifactLocation other = (ArtifactLocation)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.s3Location(), other.s3Location());
    }

    public String toString() {
        return ToString.builder((String)"ArtifactLocation").add("Type", (Object)this.typeAsString()).add("S3Location", (Object)this.s3Location()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "s3Location": {
                return Optional.ofNullable(clazz.cast(this.s3Location()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ArtifactLocation, T> g) {
        return obj -> g.apply((ArtifactLocation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private S3ArtifactLocation s3Location;

        private BuilderImpl() {
        }

        private BuilderImpl(ArtifactLocation model) {
            this.type(model.type);
            this.s3Location(model.s3Location);
        }

        public final String getTypeAsString() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ArtifactLocationType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final S3ArtifactLocation.Builder getS3Location() {
            return this.s3Location != null ? this.s3Location.toBuilder() : null;
        }

        @Override
        public final Builder s3Location(S3ArtifactLocation s3Location) {
            this.s3Location = s3Location;
            return this;
        }

        public final void setS3Location(S3ArtifactLocation.BuilderImpl s3Location) {
            this.s3Location = s3Location != null ? s3Location.build() : null;
        }

        public ArtifactLocation build() {
            return new ArtifactLocation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ArtifactLocation> {
        public Builder type(String var1);

        public Builder type(ArtifactLocationType var1);

        public Builder s3Location(S3ArtifactLocation var1);

        default public Builder s3Location(Consumer<S3ArtifactLocation.Builder> s3Location) {
            return this.s3Location((S3ArtifactLocation)((S3ArtifactLocation.Builder)S3ArtifactLocation.builder().applyMutation(s3Location)).build());
        }
    }
}

