/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codepipeline.model.DeployTargetEvent;
import software.amazon.awssdk.services.codepipeline.model.DeployTargetEventListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeployActionExecutionTarget
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DeployActionExecutionTarget> {
    private static final SdkField<String> TARGET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("targetId").getter(DeployActionExecutionTarget.getter(DeployActionExecutionTarget::targetId)).setter(DeployActionExecutionTarget.setter(Builder::targetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetId").build()}).build();
    private static final SdkField<String> TARGET_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("targetType").getter(DeployActionExecutionTarget.getter(DeployActionExecutionTarget::targetType)).setter(DeployActionExecutionTarget.setter(Builder::targetType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetType").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(DeployActionExecutionTarget.getter(DeployActionExecutionTarget::status)).setter(DeployActionExecutionTarget.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startTime").getter(DeployActionExecutionTarget.getter(DeployActionExecutionTarget::startTime)).setter(DeployActionExecutionTarget.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("endTime").getter(DeployActionExecutionTarget.getter(DeployActionExecutionTarget::endTime)).setter(DeployActionExecutionTarget.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()}).build();
    private static final SdkField<List<DeployTargetEvent>> EVENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("events").getter(DeployActionExecutionTarget.getter(DeployActionExecutionTarget::events)).setter(DeployActionExecutionTarget.setter(Builder::events)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("events").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DeployTargetEvent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_ID_FIELD, TARGET_TYPE_FIELD, STATUS_FIELD, START_TIME_FIELD, END_TIME_FIELD, EVENTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeployActionExecutionTarget.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String targetId;
    private final String targetType;
    private final String status;
    private final Instant startTime;
    private final Instant endTime;
    private final List<DeployTargetEvent> events;

    private DeployActionExecutionTarget(BuilderImpl builder) {
        this.targetId = builder.targetId;
        this.targetType = builder.targetType;
        this.status = builder.status;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.events = builder.events;
    }

    public final String targetId() {
        return this.targetId;
    }

    public final String targetType() {
        return this.targetType;
    }

    public final String status() {
        return this.status;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final boolean hasEvents() {
        return this.events != null && !(this.events instanceof SdkAutoConstructList);
    }

    public final List<DeployTargetEvent> events() {
        return this.events;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.targetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetType());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEvents() ? this.events() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeployActionExecutionTarget)) {
            return false;
        }
        DeployActionExecutionTarget other = (DeployActionExecutionTarget)obj;
        return Objects.equals(this.targetId(), other.targetId()) && Objects.equals(this.targetType(), other.targetType()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && this.hasEvents() == other.hasEvents() && Objects.equals(this.events(), other.events());
    }

    public final String toString() {
        return ToString.builder((String)"DeployActionExecutionTarget").add("TargetId", (Object)this.targetId()).add("TargetType", (Object)this.targetType()).add("Status", (Object)this.status()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("Events", this.hasEvents() ? this.events() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "targetId": {
                return Optional.ofNullable(clazz.cast(this.targetId()));
            }
            case "targetType": {
                return Optional.ofNullable(clazz.cast(this.targetType()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "startTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "endTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "events": {
                return Optional.ofNullable(clazz.cast(this.events()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("targetId", TARGET_ID_FIELD);
        map.put("targetType", TARGET_TYPE_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("startTime", START_TIME_FIELD);
        map.put("endTime", END_TIME_FIELD);
        map.put("events", EVENTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeployActionExecutionTarget, T> g) {
        return obj -> g.apply((DeployActionExecutionTarget)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String targetId;
        private String targetType;
        private String status;
        private Instant startTime;
        private Instant endTime;
        private List<DeployTargetEvent> events = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DeployActionExecutionTarget model) {
            this.targetId(model.targetId);
            this.targetType(model.targetType);
            this.status(model.status);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.events(model.events);
        }

        public final String getTargetId() {
            return this.targetId;
        }

        public final void setTargetId(String targetId) {
            this.targetId = targetId;
        }

        @Override
        public final Builder targetId(String targetId) {
            this.targetId = targetId;
            return this;
        }

        public final String getTargetType() {
            return this.targetType;
        }

        public final void setTargetType(String targetType) {
            this.targetType = targetType;
        }

        @Override
        public final Builder targetType(String targetType) {
            this.targetType = targetType;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final List<DeployTargetEvent.Builder> getEvents() {
            List<DeployTargetEvent.Builder> result = DeployTargetEventListCopier.copyToBuilder(this.events);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEvents(Collection<DeployTargetEvent.BuilderImpl> events) {
            this.events = DeployTargetEventListCopier.copyFromBuilder(events);
        }

        @Override
        public final Builder events(Collection<DeployTargetEvent> events) {
            this.events = DeployTargetEventListCopier.copy(events);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder events(DeployTargetEvent ... events) {
            this.events(Arrays.asList(events));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder events(Consumer<DeployTargetEvent.Builder> ... events) {
            this.events(Stream.of(events).map(c -> (DeployTargetEvent)((DeployTargetEvent.Builder)DeployTargetEvent.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public DeployActionExecutionTarget build() {
            return new DeployActionExecutionTarget(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DeployActionExecutionTarget> {
        public Builder targetId(String var1);

        public Builder targetType(String var1);

        public Builder status(String var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder events(Collection<DeployTargetEvent> var1);

        public Builder events(DeployTargetEvent ... var1);

        public Builder events(Consumer<DeployTargetEvent.Builder> ... var1);
    }
}

