/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codepipeline.model.Result;
import software.amazon.awssdk.services.codepipeline.model.RuleDeclaration;
import software.amazon.awssdk.services.codepipeline.model.RuleDeclarationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Condition
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Condition> {
    private static final SdkField<String> RESULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("result").getter(Condition.getter(Condition::resultAsString)).setter(Condition.setter(Builder::result)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("result").build()}).build();
    private static final SdkField<List<RuleDeclaration>> RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("rules").getter(Condition.getter(Condition::rules)).setter(Condition.setter(Builder::rules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RuleDeclaration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESULT_FIELD, RULES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Condition.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String result;
    private final List<RuleDeclaration> rules;

    private Condition(BuilderImpl builder) {
        this.result = builder.result;
        this.rules = builder.rules;
    }

    public final Result result() {
        return Result.fromValue(this.result);
    }

    public final String resultAsString() {
        return this.result;
    }

    public final boolean hasRules() {
        return this.rules != null && !(this.rules instanceof SdkAutoConstructList);
    }

    public final List<RuleDeclaration> rules() {
        return this.rules;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resultAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRules() ? this.rules() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Condition)) {
            return false;
        }
        Condition other = (Condition)obj;
        return Objects.equals(this.resultAsString(), other.resultAsString()) && this.hasRules() == other.hasRules() && Objects.equals(this.rules(), other.rules());
    }

    public final String toString() {
        return ToString.builder((String)"Condition").add("Result", (Object)this.resultAsString()).add("Rules", this.hasRules() ? this.rules() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "result": {
                return Optional.ofNullable(clazz.cast(this.resultAsString()));
            }
            case "rules": {
                return Optional.ofNullable(clazz.cast(this.rules()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("result", RESULT_FIELD);
        map.put("rules", RULES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Condition, T> g) {
        return obj -> g.apply((Condition)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String result;
        private List<RuleDeclaration> rules = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Condition model) {
            this.result(model.result);
            this.rules(model.rules);
        }

        public final String getResult() {
            return this.result;
        }

        public final void setResult(String result) {
            this.result = result;
        }

        @Override
        public final Builder result(String result) {
            this.result = result;
            return this;
        }

        @Override
        public final Builder result(Result result) {
            this.result(result == null ? null : result.toString());
            return this;
        }

        public final List<RuleDeclaration.Builder> getRules() {
            List<RuleDeclaration.Builder> result = RuleDeclarationListCopier.copyToBuilder(this.rules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRules(Collection<RuleDeclaration.BuilderImpl> rules) {
            this.rules = RuleDeclarationListCopier.copyFromBuilder(rules);
        }

        @Override
        public final Builder rules(Collection<RuleDeclaration> rules) {
            this.rules = RuleDeclarationListCopier.copy(rules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(RuleDeclaration ... rules) {
            this.rules(Arrays.asList(rules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(Consumer<RuleDeclaration.Builder> ... rules) {
            this.rules(Stream.of(rules).map(c -> (RuleDeclaration)((RuleDeclaration.Builder)RuleDeclaration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public Condition build() {
            return new Condition(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Condition> {
        public Builder result(String var1);

        public Builder result(Result var1);

        public Builder rules(Collection<RuleDeclaration> var1);

        public Builder rules(RuleDeclaration ... var1);

        public Builder rules(Consumer<RuleDeclaration.Builder> ... var1);
    }
}

