/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum RuleCategory {
    RULE("Rule"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, RuleCategory> VALUE_MAP;
    private final String value;

    private RuleCategory(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RuleCategory fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RuleCategory> knownValues() {
        EnumSet<RuleCategory> knownValues = EnumSet.allOf(RuleCategory.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(RuleCategory.class, RuleCategory::toString);
    }
}

