/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.codepipeline.CodePipelineAsyncClient;
import software.amazon.awssdk.services.codepipeline.internal.UserAgentUtils;
import software.amazon.awssdk.services.codepipeline.model.ListWebhookItem;
import software.amazon.awssdk.services.codepipeline.model.ListWebhooksRequest;
import software.amazon.awssdk.services.codepipeline.model.ListWebhooksResponse;

public class ListWebhooksPublisher
implements SdkPublisher<ListWebhooksResponse> {
    private final CodePipelineAsyncClient client;
    private final ListWebhooksRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListWebhooksPublisher(CodePipelineAsyncClient client, ListWebhooksRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListWebhooksPublisher(CodePipelineAsyncClient client, ListWebhooksRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListWebhooksResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListWebhooksResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ListWebhookItem> webhooks() {
        Function<ListWebhooksResponse, Iterator> getIterator = response -> {
            if (response != null && response.webhooks() != null) {
                return response.webhooks().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListWebhooksResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListWebhooksResponseFetcher
    implements AsyncPageFetcher<ListWebhooksResponse> {
        private ListWebhooksResponseFetcher() {
        }

        public boolean hasNextPage(ListWebhooksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListWebhooksResponse> nextPage(ListWebhooksResponse previousPage) {
            if (previousPage == null) {
                return ListWebhooksPublisher.this.client.listWebhooks(ListWebhooksPublisher.this.firstRequest);
            }
            return ListWebhooksPublisher.this.client.listWebhooks((ListWebhooksRequest)((Object)ListWebhooksPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

