/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codepipeline.model.AllowedAccountsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ActionTypePermissions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ActionTypePermissions> {
    private static final SdkField<List<String>> ALLOWED_ACCOUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("allowedAccounts").getter(ActionTypePermissions.getter(ActionTypePermissions::allowedAccounts)).setter(ActionTypePermissions.setter(Builder::allowedAccounts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowedAccounts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALLOWED_ACCOUNTS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> allowedAccounts;

    private ActionTypePermissions(BuilderImpl builder) {
        this.allowedAccounts = builder.allowedAccounts;
    }

    public final boolean hasAllowedAccounts() {
        return this.allowedAccounts != null && !(this.allowedAccounts instanceof SdkAutoConstructList);
    }

    public final List<String> allowedAccounts() {
        return this.allowedAccounts;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAllowedAccounts() ? this.allowedAccounts() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActionTypePermissions)) {
            return false;
        }
        ActionTypePermissions other = (ActionTypePermissions)obj;
        return this.hasAllowedAccounts() == other.hasAllowedAccounts() && Objects.equals(this.allowedAccounts(), other.allowedAccounts());
    }

    public final String toString() {
        return ToString.builder((String)"ActionTypePermissions").add("AllowedAccounts", this.hasAllowedAccounts() ? this.allowedAccounts() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "allowedAccounts": {
                return Optional.ofNullable(clazz.cast(this.allowedAccounts()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ActionTypePermissions, T> g) {
        return obj -> g.apply((ActionTypePermissions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> allowedAccounts = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ActionTypePermissions model) {
            this.allowedAccounts(model.allowedAccounts);
        }

        public final Collection<String> getAllowedAccounts() {
            if (this.allowedAccounts instanceof SdkAutoConstructList) {
                return null;
            }
            return this.allowedAccounts;
        }

        public final void setAllowedAccounts(Collection<String> allowedAccounts) {
            this.allowedAccounts = AllowedAccountsCopier.copy(allowedAccounts);
        }

        @Override
        public final Builder allowedAccounts(Collection<String> allowedAccounts) {
            this.allowedAccounts = AllowedAccountsCopier.copy(allowedAccounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedAccounts(String ... allowedAccounts) {
            this.allowedAccounts(Arrays.asList(allowedAccounts));
            return this;
        }

        public ActionTypePermissions build() {
            return new ActionTypePermissions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ActionTypePermissions> {
        public Builder allowedAccounts(Collection<String> var1);

        public Builder allowedAccounts(String ... var1);
    }
}

