/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codepipeline.model.Tag;
import software.amazon.awssdk.services.codepipeline.model.TagListCopier;
import software.amazon.awssdk.services.codepipeline.model.WebhookDefinition;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListWebhookItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ListWebhookItem> {
    private static final SdkField<WebhookDefinition> DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("definition").getter(ListWebhookItem.getter(ListWebhookItem::definition)).setter(ListWebhookItem.setter(Builder::definition)).constructor(WebhookDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("definition").build()}).build();
    private static final SdkField<String> URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("url").getter(ListWebhookItem.getter(ListWebhookItem::url)).setter(ListWebhookItem.setter(Builder::url)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("url").build()}).build();
    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("errorMessage").getter(ListWebhookItem.getter(ListWebhookItem::errorMessage)).setter(ListWebhookItem.setter(Builder::errorMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorMessage").build()}).build();
    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("errorCode").getter(ListWebhookItem.getter(ListWebhookItem::errorCode)).setter(ListWebhookItem.setter(Builder::errorCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorCode").build()}).build();
    private static final SdkField<Instant> LAST_TRIGGERED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastTriggered").getter(ListWebhookItem.getter(ListWebhookItem::lastTriggered)).setter(ListWebhookItem.setter(Builder::lastTriggered)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastTriggered").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(ListWebhookItem.getter(ListWebhookItem::arn)).setter(ListWebhookItem.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(ListWebhookItem.getter(ListWebhookItem::tags)).setter(ListWebhookItem.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEFINITION_FIELD, URL_FIELD, ERROR_MESSAGE_FIELD, ERROR_CODE_FIELD, LAST_TRIGGERED_FIELD, ARN_FIELD, TAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final WebhookDefinition definition;
    private final String url;
    private final String errorMessage;
    private final String errorCode;
    private final Instant lastTriggered;
    private final String arn;
    private final List<Tag> tags;

    private ListWebhookItem(BuilderImpl builder) {
        this.definition = builder.definition;
        this.url = builder.url;
        this.errorMessage = builder.errorMessage;
        this.errorCode = builder.errorCode;
        this.lastTriggered = builder.lastTriggered;
        this.arn = builder.arn;
        this.tags = builder.tags;
    }

    public final WebhookDefinition definition() {
        return this.definition;
    }

    public final String url() {
        return this.url;
    }

    public final String errorMessage() {
        return this.errorMessage;
    }

    public final String errorCode() {
        return this.errorCode;
    }

    public final Instant lastTriggered() {
        return this.lastTriggered;
    }

    public final String arn() {
        return this.arn;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.definition());
        hashCode = 31 * hashCode + Objects.hashCode(this.url());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastTriggered());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListWebhookItem)) {
            return false;
        }
        ListWebhookItem other = (ListWebhookItem)obj;
        return Objects.equals(this.definition(), other.definition()) && Objects.equals(this.url(), other.url()) && Objects.equals(this.errorMessage(), other.errorMessage()) && Objects.equals(this.errorCode(), other.errorCode()) && Objects.equals(this.lastTriggered(), other.lastTriggered()) && Objects.equals(this.arn(), other.arn()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"ListWebhookItem").add("Definition", (Object)this.definition()).add("Url", (Object)this.url()).add("ErrorMessage", (Object)this.errorMessage()).add("ErrorCode", (Object)this.errorCode()).add("LastTriggered", (Object)this.lastTriggered()).add("Arn", (Object)this.arn()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "definition": {
                return Optional.ofNullable(clazz.cast(this.definition()));
            }
            case "url": {
                return Optional.ofNullable(clazz.cast(this.url()));
            }
            case "errorMessage": {
                return Optional.ofNullable(clazz.cast(this.errorMessage()));
            }
            case "errorCode": {
                return Optional.ofNullable(clazz.cast(this.errorCode()));
            }
            case "lastTriggered": {
                return Optional.ofNullable(clazz.cast(this.lastTriggered()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListWebhookItem, T> g) {
        return obj -> g.apply((ListWebhookItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private WebhookDefinition definition;
        private String url;
        private String errorMessage;
        private String errorCode;
        private Instant lastTriggered;
        private String arn;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListWebhookItem model) {
            this.definition(model.definition);
            this.url(model.url);
            this.errorMessage(model.errorMessage);
            this.errorCode(model.errorCode);
            this.lastTriggered(model.lastTriggered);
            this.arn(model.arn);
            this.tags(model.tags);
        }

        public final WebhookDefinition.Builder getDefinition() {
            return this.definition != null ? this.definition.toBuilder() : null;
        }

        public final void setDefinition(WebhookDefinition.BuilderImpl definition) {
            this.definition = definition != null ? definition.build() : null;
        }

        @Override
        @Transient
        public final Builder definition(WebhookDefinition definition) {
            this.definition = definition;
            return this;
        }

        public final String getUrl() {
            return this.url;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        @Override
        @Transient
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final String getErrorMessage() {
            return this.errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        @Transient
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final String getErrorCode() {
            return this.errorCode;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        @Override
        @Transient
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public final Instant getLastTriggered() {
            return this.lastTriggered;
        }

        public final void setLastTriggered(Instant lastTriggered) {
            this.lastTriggered = lastTriggered;
        }

        @Override
        @Transient
        public final Builder lastTriggered(Instant lastTriggered) {
            this.lastTriggered = lastTriggered;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        @Transient
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        @Transient
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ListWebhookItem build() {
            return new ListWebhookItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ListWebhookItem> {
        public Builder definition(WebhookDefinition var1);

        default public Builder definition(Consumer<WebhookDefinition.Builder> definition) {
            return this.definition((WebhookDefinition)((WebhookDefinition.Builder)WebhookDefinition.builder().applyMutation(definition)).build());
        }

        public Builder url(String var1);

        public Builder errorMessage(String var1);

        public Builder errorCode(String var1);

        public Builder lastTriggered(Instant var1);

        public Builder arn(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

