/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codepipeline.model.JobData;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Job
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Job> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(Job.getter(Job::id)).setter(Job.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<JobData> DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("data").getter(Job.getter(Job::data)).setter(Job.setter(Builder::data)).constructor(JobData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("data").build()}).build();
    private static final SdkField<String> NONCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nonce").getter(Job.getter(Job::nonce)).setter(Job.setter(Builder::nonce)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nonce").build()}).build();
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accountId").getter(Job.getter(Job::accountId)).setter(Job.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, DATA_FIELD, NONCE_FIELD, ACCOUNT_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String id;
    private final JobData data;
    private final String nonce;
    private final String accountId;

    private Job(BuilderImpl builder) {
        this.id = builder.id;
        this.data = builder.data;
        this.nonce = builder.nonce;
        this.accountId = builder.accountId;
    }

    public final String id() {
        return this.id;
    }

    public final JobData data() {
        return this.data;
    }

    public final String nonce() {
        return this.nonce;
    }

    public final String accountId() {
        return this.accountId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.data());
        hashCode = 31 * hashCode + Objects.hashCode(this.nonce());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Job)) {
            return false;
        }
        Job other = (Job)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.data(), other.data()) && Objects.equals(this.nonce(), other.nonce()) && Objects.equals(this.accountId(), other.accountId());
    }

    public final String toString() {
        return ToString.builder((String)"Job").add("Id", (Object)this.id()).add("Data", (Object)this.data()).add("Nonce", (Object)this.nonce()).add("AccountId", (Object)this.accountId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "data": {
                return Optional.ofNullable(clazz.cast(this.data()));
            }
            case "nonce": {
                return Optional.ofNullable(clazz.cast(this.nonce()));
            }
            case "accountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Job, T> g) {
        return obj -> g.apply((Job)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private JobData data;
        private String nonce;
        private String accountId;

        private BuilderImpl() {
        }

        private BuilderImpl(Job model) {
            this.id(model.id);
            this.data(model.data);
            this.nonce(model.nonce);
            this.accountId(model.accountId);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        @Transient
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final JobData.Builder getData() {
            return this.data != null ? this.data.toBuilder() : null;
        }

        public final void setData(JobData.BuilderImpl data) {
            this.data = data != null ? data.build() : null;
        }

        @Override
        @Transient
        public final Builder data(JobData data) {
            this.data = data;
            return this;
        }

        public final String getNonce() {
            return this.nonce;
        }

        public final void setNonce(String nonce) {
            this.nonce = nonce;
        }

        @Override
        @Transient
        public final Builder nonce(String nonce) {
            this.nonce = nonce;
            return this;
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        @Transient
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public Job build() {
            return new Job(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Job> {
        public Builder id(String var1);

        public Builder data(JobData var1);

        default public Builder data(Consumer<JobData.Builder> data) {
            return this.data((JobData)((JobData.Builder)JobData.builder().applyMutation(data)).build());
        }

        public Builder nonce(String var1);

        public Builder accountId(String var1);
    }
}

