/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.codepipeline.model.ActionConfigurationMapCopier;
import software.amazon.awssdk.services.codepipeline.model.ActionTypeId;
import software.amazon.awssdk.services.codepipeline.model.InputArtifact;
import software.amazon.awssdk.services.codepipeline.model.InputArtifactListCopier;
import software.amazon.awssdk.services.codepipeline.model.OutputArtifact;
import software.amazon.awssdk.services.codepipeline.model.OutputArtifactListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ActionDeclaration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ActionDeclaration> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(ActionDeclaration.getter(ActionDeclaration::name)).setter(ActionDeclaration.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<ActionTypeId> ACTION_TYPE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("actionTypeId").getter(ActionDeclaration.getter(ActionDeclaration::actionTypeId)).setter(ActionDeclaration.setter(Builder::actionTypeId)).constructor(ActionTypeId::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionTypeId").build()}).build();
    private static final SdkField<Integer> RUN_ORDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("runOrder").getter(ActionDeclaration.getter(ActionDeclaration::runOrder)).setter(ActionDeclaration.setter(Builder::runOrder)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runOrder").build()}).build();
    private static final SdkField<Map<String, String>> CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("configuration").getter(ActionDeclaration.getter(ActionDeclaration::configuration)).setter(ActionDeclaration.setter(Builder::configuration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<OutputArtifact>> OUTPUT_ARTIFACTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("outputArtifacts").getter(ActionDeclaration.getter(ActionDeclaration::outputArtifacts)).setter(ActionDeclaration.setter(Builder::outputArtifacts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputArtifacts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OutputArtifact::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<InputArtifact>> INPUT_ARTIFACTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("inputArtifacts").getter(ActionDeclaration.getter(ActionDeclaration::inputArtifacts)).setter(ActionDeclaration.setter(Builder::inputArtifacts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputArtifacts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InputArtifact::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(ActionDeclaration.getter(ActionDeclaration::roleArn)).setter(ActionDeclaration.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<String> REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("region").getter(ActionDeclaration.getter(ActionDeclaration::region)).setter(ActionDeclaration.setter(Builder::region)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("region").build()}).build();
    private static final SdkField<String> NAMESPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("namespace").getter(ActionDeclaration.getter(ActionDeclaration::namespace)).setter(ActionDeclaration.setter(Builder::namespace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespace").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ACTION_TYPE_ID_FIELD, RUN_ORDER_FIELD, CONFIGURATION_FIELD, OUTPUT_ARTIFACTS_FIELD, INPUT_ARTIFACTS_FIELD, ROLE_ARN_FIELD, REGION_FIELD, NAMESPACE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final ActionTypeId actionTypeId;
    private final Integer runOrder;
    private final Map<String, String> configuration;
    private final List<OutputArtifact> outputArtifacts;
    private final List<InputArtifact> inputArtifacts;
    private final String roleArn;
    private final String region;
    private final String namespace;

    private ActionDeclaration(BuilderImpl builder) {
        this.name = builder.name;
        this.actionTypeId = builder.actionTypeId;
        this.runOrder = builder.runOrder;
        this.configuration = builder.configuration;
        this.outputArtifacts = builder.outputArtifacts;
        this.inputArtifacts = builder.inputArtifacts;
        this.roleArn = builder.roleArn;
        this.region = builder.region;
        this.namespace = builder.namespace;
    }

    public final String name() {
        return this.name;
    }

    public final ActionTypeId actionTypeId() {
        return this.actionTypeId;
    }

    public final Integer runOrder() {
        return this.runOrder;
    }

    public final boolean hasConfiguration() {
        return this.configuration != null && !(this.configuration instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> configuration() {
        return this.configuration;
    }

    public final boolean hasOutputArtifacts() {
        return this.outputArtifacts != null && !(this.outputArtifacts instanceof SdkAutoConstructList);
    }

    public final List<OutputArtifact> outputArtifacts() {
        return this.outputArtifacts;
    }

    public final boolean hasInputArtifacts() {
        return this.inputArtifacts != null && !(this.inputArtifacts instanceof SdkAutoConstructList);
    }

    public final List<InputArtifact> inputArtifacts() {
        return this.inputArtifacts;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final String region() {
        return this.region;
    }

    public final String namespace() {
        return this.namespace;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionTypeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.runOrder());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConfiguration() ? this.configuration() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOutputArtifacts() ? this.outputArtifacts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInputArtifacts() ? this.inputArtifacts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.region());
        hashCode = 31 * hashCode + Objects.hashCode(this.namespace());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActionDeclaration)) {
            return false;
        }
        ActionDeclaration other = (ActionDeclaration)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.actionTypeId(), other.actionTypeId()) && Objects.equals(this.runOrder(), other.runOrder()) && this.hasConfiguration() == other.hasConfiguration() && Objects.equals(this.configuration(), other.configuration()) && this.hasOutputArtifacts() == other.hasOutputArtifacts() && Objects.equals(this.outputArtifacts(), other.outputArtifacts()) && this.hasInputArtifacts() == other.hasInputArtifacts() && Objects.equals(this.inputArtifacts(), other.inputArtifacts()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.region(), other.region()) && Objects.equals(this.namespace(), other.namespace());
    }

    public final String toString() {
        return ToString.builder((String)"ActionDeclaration").add("Name", (Object)this.name()).add("ActionTypeId", (Object)this.actionTypeId()).add("RunOrder", (Object)this.runOrder()).add("Configuration", this.hasConfiguration() ? this.configuration() : null).add("OutputArtifacts", this.hasOutputArtifacts() ? this.outputArtifacts() : null).add("InputArtifacts", this.hasInputArtifacts() ? this.inputArtifacts() : null).add("RoleArn", (Object)this.roleArn()).add("Region", (Object)this.region()).add("Namespace", (Object)this.namespace()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "actionTypeId": {
                return Optional.ofNullable(clazz.cast(this.actionTypeId()));
            }
            case "runOrder": {
                return Optional.ofNullable(clazz.cast(this.runOrder()));
            }
            case "configuration": {
                return Optional.ofNullable(clazz.cast(this.configuration()));
            }
            case "outputArtifacts": {
                return Optional.ofNullable(clazz.cast(this.outputArtifacts()));
            }
            case "inputArtifacts": {
                return Optional.ofNullable(clazz.cast(this.inputArtifacts()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "region": {
                return Optional.ofNullable(clazz.cast(this.region()));
            }
            case "namespace": {
                return Optional.ofNullable(clazz.cast(this.namespace()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ActionDeclaration, T> g) {
        return obj -> g.apply((ActionDeclaration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private ActionTypeId actionTypeId;
        private Integer runOrder;
        private Map<String, String> configuration = DefaultSdkAutoConstructMap.getInstance();
        private List<OutputArtifact> outputArtifacts = DefaultSdkAutoConstructList.getInstance();
        private List<InputArtifact> inputArtifacts = DefaultSdkAutoConstructList.getInstance();
        private String roleArn;
        private String region;
        private String namespace;

        private BuilderImpl() {
        }

        private BuilderImpl(ActionDeclaration model) {
            this.name(model.name);
            this.actionTypeId(model.actionTypeId);
            this.runOrder(model.runOrder);
            this.configuration(model.configuration);
            this.outputArtifacts(model.outputArtifacts);
            this.inputArtifacts(model.inputArtifacts);
            this.roleArn(model.roleArn);
            this.region(model.region);
            this.namespace(model.namespace);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final ActionTypeId.Builder getActionTypeId() {
            return this.actionTypeId != null ? this.actionTypeId.toBuilder() : null;
        }

        public final void setActionTypeId(ActionTypeId.BuilderImpl actionTypeId) {
            this.actionTypeId = actionTypeId != null ? actionTypeId.build() : null;
        }

        @Override
        @Transient
        public final Builder actionTypeId(ActionTypeId actionTypeId) {
            this.actionTypeId = actionTypeId;
            return this;
        }

        public final Integer getRunOrder() {
            return this.runOrder;
        }

        public final void setRunOrder(Integer runOrder) {
            this.runOrder = runOrder;
        }

        @Override
        @Transient
        public final Builder runOrder(Integer runOrder) {
            this.runOrder = runOrder;
            return this;
        }

        public final Map<String, String> getConfiguration() {
            if (this.configuration instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.configuration;
        }

        public final void setConfiguration(Map<String, String> configuration) {
            this.configuration = ActionConfigurationMapCopier.copy(configuration);
        }

        @Override
        @Transient
        public final Builder configuration(Map<String, String> configuration) {
            this.configuration = ActionConfigurationMapCopier.copy(configuration);
            return this;
        }

        public final List<OutputArtifact.Builder> getOutputArtifacts() {
            List<OutputArtifact.Builder> result = OutputArtifactListCopier.copyToBuilder(this.outputArtifacts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOutputArtifacts(Collection<OutputArtifact.BuilderImpl> outputArtifacts) {
            this.outputArtifacts = OutputArtifactListCopier.copyFromBuilder(outputArtifacts);
        }

        @Override
        @Transient
        public final Builder outputArtifacts(Collection<OutputArtifact> outputArtifacts) {
            this.outputArtifacts = OutputArtifactListCopier.copy(outputArtifacts);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder outputArtifacts(OutputArtifact ... outputArtifacts) {
            this.outputArtifacts(Arrays.asList(outputArtifacts));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder outputArtifacts(Consumer<OutputArtifact.Builder> ... outputArtifacts) {
            this.outputArtifacts(Stream.of(outputArtifacts).map(c -> (OutputArtifact)((OutputArtifact.Builder)OutputArtifact.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<InputArtifact.Builder> getInputArtifacts() {
            List<InputArtifact.Builder> result = InputArtifactListCopier.copyToBuilder(this.inputArtifacts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInputArtifacts(Collection<InputArtifact.BuilderImpl> inputArtifacts) {
            this.inputArtifacts = InputArtifactListCopier.copyFromBuilder(inputArtifacts);
        }

        @Override
        @Transient
        public final Builder inputArtifacts(Collection<InputArtifact> inputArtifacts) {
            this.inputArtifacts = InputArtifactListCopier.copy(inputArtifacts);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder inputArtifacts(InputArtifact ... inputArtifacts) {
            this.inputArtifacts(Arrays.asList(inputArtifacts));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder inputArtifacts(Consumer<InputArtifact.Builder> ... inputArtifacts) {
            this.inputArtifacts(Stream.of(inputArtifacts).map(c -> (InputArtifact)((InputArtifact.Builder)InputArtifact.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        @Transient
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getRegion() {
            return this.region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        @Transient
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final String getNamespace() {
            return this.namespace;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        @Transient
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public ActionDeclaration build() {
            return new ActionDeclaration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ActionDeclaration> {
        public Builder name(String var1);

        public Builder actionTypeId(ActionTypeId var1);

        default public Builder actionTypeId(Consumer<ActionTypeId.Builder> actionTypeId) {
            return this.actionTypeId((ActionTypeId)((ActionTypeId.Builder)ActionTypeId.builder().applyMutation(actionTypeId)).build());
        }

        public Builder runOrder(Integer var1);

        public Builder configuration(Map<String, String> var1);

        public Builder outputArtifacts(Collection<OutputArtifact> var1);

        public Builder outputArtifacts(OutputArtifact ... var1);

        public Builder outputArtifacts(Consumer<OutputArtifact.Builder> ... var1);

        public Builder inputArtifacts(Collection<InputArtifact> var1);

        public Builder inputArtifacts(InputArtifact ... var1);

        public Builder inputArtifacts(Consumer<InputArtifact.Builder> ... var1);

        public Builder roleArn(String var1);

        public Builder region(String var1);

        public Builder namespace(String var1);
    }
}

