/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codepipeline.model.CodePipelineResponse;
import software.amazon.awssdk.services.codepipeline.model.ThirdPartyJob;
import software.amazon.awssdk.services.codepipeline.model.ThirdPartyJobListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PollForThirdPartyJobsResponse
extends CodePipelineResponse
implements ToCopyableBuilder<Builder, PollForThirdPartyJobsResponse> {
    private static final SdkField<List<ThirdPartyJob>> JOBS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("jobs").getter(PollForThirdPartyJobsResponse.getter(PollForThirdPartyJobsResponse::jobs)).setter(PollForThirdPartyJobsResponse.setter(Builder::jobs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ThirdPartyJob::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOBS_FIELD));
    private final List<ThirdPartyJob> jobs;

    private PollForThirdPartyJobsResponse(BuilderImpl builder) {
        super(builder);
        this.jobs = builder.jobs;
    }

    public final boolean hasJobs() {
        return this.jobs != null && !(this.jobs instanceof SdkAutoConstructList);
    }

    public final List<ThirdPartyJob> jobs() {
        return this.jobs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasJobs() ? this.jobs() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PollForThirdPartyJobsResponse)) {
            return false;
        }
        PollForThirdPartyJobsResponse other = (PollForThirdPartyJobsResponse)((Object)obj);
        return this.hasJobs() == other.hasJobs() && Objects.equals(this.jobs(), other.jobs());
    }

    public final String toString() {
        return ToString.builder((String)"PollForThirdPartyJobsResponse").add("Jobs", this.hasJobs() ? this.jobs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "jobs": {
                return Optional.ofNullable(clazz.cast(this.jobs()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PollForThirdPartyJobsResponse, T> g) {
        return obj -> g.apply((PollForThirdPartyJobsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodePipelineResponse.BuilderImpl
    implements Builder {
        private List<ThirdPartyJob> jobs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PollForThirdPartyJobsResponse model) {
            super(model);
            this.jobs(model.jobs);
        }

        public final Collection<ThirdPartyJob.Builder> getJobs() {
            if (this.jobs instanceof SdkAutoConstructList) {
                return null;
            }
            return this.jobs != null ? (Collection)this.jobs.stream().map(ThirdPartyJob::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder jobs(Collection<ThirdPartyJob> jobs) {
            this.jobs = ThirdPartyJobListCopier.copy(jobs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobs(ThirdPartyJob ... jobs) {
            this.jobs(Arrays.asList(jobs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobs(Consumer<ThirdPartyJob.Builder> ... jobs) {
            this.jobs(Stream.of(jobs).map(c -> (ThirdPartyJob)((ThirdPartyJob.Builder)ThirdPartyJob.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setJobs(Collection<ThirdPartyJob.BuilderImpl> jobs) {
            this.jobs = ThirdPartyJobListCopier.copyFromBuilder(jobs);
        }

        @Override
        public PollForThirdPartyJobsResponse build() {
            return new PollForThirdPartyJobsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodePipelineResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PollForThirdPartyJobsResponse> {
        public Builder jobs(Collection<ThirdPartyJob> var1);

        public Builder jobs(ThirdPartyJob ... var1);

        public Builder jobs(Consumer<ThirdPartyJob.Builder> ... var1);
    }
}

