/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codepipeline.model.AWSSessionCredentials;
import software.amazon.awssdk.services.codepipeline.model.ActionConfiguration;
import software.amazon.awssdk.services.codepipeline.model.ActionTypeId;
import software.amazon.awssdk.services.codepipeline.model.Artifact;
import software.amazon.awssdk.services.codepipeline.model.ArtifactListCopier;
import software.amazon.awssdk.services.codepipeline.model.EncryptionKey;
import software.amazon.awssdk.services.codepipeline.model.PipelineContext;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class JobData
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, JobData> {
    private static final SdkField<ActionTypeId> ACTION_TYPE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("actionTypeId").getter(JobData.getter(JobData::actionTypeId)).setter(JobData.setter(Builder::actionTypeId)).constructor(ActionTypeId::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionTypeId").build()}).build();
    private static final SdkField<ActionConfiguration> ACTION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("actionConfiguration").getter(JobData.getter(JobData::actionConfiguration)).setter(JobData.setter(Builder::actionConfiguration)).constructor(ActionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionConfiguration").build()}).build();
    private static final SdkField<PipelineContext> PIPELINE_CONTEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("pipelineContext").getter(JobData.getter(JobData::pipelineContext)).setter(JobData.setter(Builder::pipelineContext)).constructor(PipelineContext::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipelineContext").build()}).build();
    private static final SdkField<List<Artifact>> INPUT_ARTIFACTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("inputArtifacts").getter(JobData.getter(JobData::inputArtifacts)).setter(JobData.setter(Builder::inputArtifacts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputArtifacts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Artifact::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Artifact>> OUTPUT_ARTIFACTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("outputArtifacts").getter(JobData.getter(JobData::outputArtifacts)).setter(JobData.setter(Builder::outputArtifacts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputArtifacts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Artifact::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<AWSSessionCredentials> ARTIFACT_CREDENTIALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("artifactCredentials").getter(JobData.getter(JobData::artifactCredentials)).setter(JobData.setter(Builder::artifactCredentials)).constructor(AWSSessionCredentials::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("artifactCredentials").build()}).build();
    private static final SdkField<String> CONTINUATION_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("continuationToken").getter(JobData.getter(JobData::continuationToken)).setter(JobData.setter(Builder::continuationToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("continuationToken").build()}).build();
    private static final SdkField<EncryptionKey> ENCRYPTION_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("encryptionKey").getter(JobData.getter(JobData::encryptionKey)).setter(JobData.setter(Builder::encryptionKey)).constructor(EncryptionKey::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionKey").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_TYPE_ID_FIELD, ACTION_CONFIGURATION_FIELD, PIPELINE_CONTEXT_FIELD, INPUT_ARTIFACTS_FIELD, OUTPUT_ARTIFACTS_FIELD, ARTIFACT_CREDENTIALS_FIELD, CONTINUATION_TOKEN_FIELD, ENCRYPTION_KEY_FIELD));
    private static final long serialVersionUID = 1L;
    private final ActionTypeId actionTypeId;
    private final ActionConfiguration actionConfiguration;
    private final PipelineContext pipelineContext;
    private final List<Artifact> inputArtifacts;
    private final List<Artifact> outputArtifacts;
    private final AWSSessionCredentials artifactCredentials;
    private final String continuationToken;
    private final EncryptionKey encryptionKey;

    private JobData(BuilderImpl builder) {
        this.actionTypeId = builder.actionTypeId;
        this.actionConfiguration = builder.actionConfiguration;
        this.pipelineContext = builder.pipelineContext;
        this.inputArtifacts = builder.inputArtifacts;
        this.outputArtifacts = builder.outputArtifacts;
        this.artifactCredentials = builder.artifactCredentials;
        this.continuationToken = builder.continuationToken;
        this.encryptionKey = builder.encryptionKey;
    }

    public ActionTypeId actionTypeId() {
        return this.actionTypeId;
    }

    public ActionConfiguration actionConfiguration() {
        return this.actionConfiguration;
    }

    public PipelineContext pipelineContext() {
        return this.pipelineContext;
    }

    public boolean hasInputArtifacts() {
        return this.inputArtifacts != null && !(this.inputArtifacts instanceof SdkAutoConstructList);
    }

    public List<Artifact> inputArtifacts() {
        return this.inputArtifacts;
    }

    public boolean hasOutputArtifacts() {
        return this.outputArtifacts != null && !(this.outputArtifacts instanceof SdkAutoConstructList);
    }

    public List<Artifact> outputArtifacts() {
        return this.outputArtifacts;
    }

    public AWSSessionCredentials artifactCredentials() {
        return this.artifactCredentials;
    }

    public String continuationToken() {
        return this.continuationToken;
    }

    public EncryptionKey encryptionKey() {
        return this.encryptionKey;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.actionTypeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineContext());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInputArtifacts() ? this.inputArtifacts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOutputArtifacts() ? this.outputArtifacts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.artifactCredentials());
        hashCode = 31 * hashCode + Objects.hashCode(this.continuationToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionKey());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobData)) {
            return false;
        }
        JobData other = (JobData)obj;
        return Objects.equals(this.actionTypeId(), other.actionTypeId()) && Objects.equals(this.actionConfiguration(), other.actionConfiguration()) && Objects.equals(this.pipelineContext(), other.pipelineContext()) && this.hasInputArtifacts() == other.hasInputArtifacts() && Objects.equals(this.inputArtifacts(), other.inputArtifacts()) && this.hasOutputArtifacts() == other.hasOutputArtifacts() && Objects.equals(this.outputArtifacts(), other.outputArtifacts()) && Objects.equals(this.artifactCredentials(), other.artifactCredentials()) && Objects.equals(this.continuationToken(), other.continuationToken()) && Objects.equals(this.encryptionKey(), other.encryptionKey());
    }

    public String toString() {
        return ToString.builder((String)"JobData").add("ActionTypeId", (Object)this.actionTypeId()).add("ActionConfiguration", (Object)this.actionConfiguration()).add("PipelineContext", (Object)this.pipelineContext()).add("InputArtifacts", this.hasInputArtifacts() ? this.inputArtifacts() : null).add("OutputArtifacts", this.hasOutputArtifacts() ? this.outputArtifacts() : null).add("ArtifactCredentials", (Object)(this.artifactCredentials() == null ? null : "*** Sensitive Data Redacted ***")).add("ContinuationToken", (Object)this.continuationToken()).add("EncryptionKey", (Object)this.encryptionKey()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "actionTypeId": {
                return Optional.ofNullable(clazz.cast(this.actionTypeId()));
            }
            case "actionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.actionConfiguration()));
            }
            case "pipelineContext": {
                return Optional.ofNullable(clazz.cast(this.pipelineContext()));
            }
            case "inputArtifacts": {
                return Optional.ofNullable(clazz.cast(this.inputArtifacts()));
            }
            case "outputArtifacts": {
                return Optional.ofNullable(clazz.cast(this.outputArtifacts()));
            }
            case "artifactCredentials": {
                return Optional.ofNullable(clazz.cast(this.artifactCredentials()));
            }
            case "continuationToken": {
                return Optional.ofNullable(clazz.cast(this.continuationToken()));
            }
            case "encryptionKey": {
                return Optional.ofNullable(clazz.cast(this.encryptionKey()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JobData, T> g) {
        return obj -> g.apply((JobData)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ActionTypeId actionTypeId;
        private ActionConfiguration actionConfiguration;
        private PipelineContext pipelineContext;
        private List<Artifact> inputArtifacts = DefaultSdkAutoConstructList.getInstance();
        private List<Artifact> outputArtifacts = DefaultSdkAutoConstructList.getInstance();
        private AWSSessionCredentials artifactCredentials;
        private String continuationToken;
        private EncryptionKey encryptionKey;

        private BuilderImpl() {
        }

        private BuilderImpl(JobData model) {
            this.actionTypeId(model.actionTypeId);
            this.actionConfiguration(model.actionConfiguration);
            this.pipelineContext(model.pipelineContext);
            this.inputArtifacts(model.inputArtifacts);
            this.outputArtifacts(model.outputArtifacts);
            this.artifactCredentials(model.artifactCredentials);
            this.continuationToken(model.continuationToken);
            this.encryptionKey(model.encryptionKey);
        }

        public final ActionTypeId.Builder getActionTypeId() {
            return this.actionTypeId != null ? this.actionTypeId.toBuilder() : null;
        }

        @Override
        public final Builder actionTypeId(ActionTypeId actionTypeId) {
            this.actionTypeId = actionTypeId;
            return this;
        }

        public final void setActionTypeId(ActionTypeId.BuilderImpl actionTypeId) {
            this.actionTypeId = actionTypeId != null ? actionTypeId.build() : null;
        }

        public final ActionConfiguration.Builder getActionConfiguration() {
            return this.actionConfiguration != null ? this.actionConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder actionConfiguration(ActionConfiguration actionConfiguration) {
            this.actionConfiguration = actionConfiguration;
            return this;
        }

        public final void setActionConfiguration(ActionConfiguration.BuilderImpl actionConfiguration) {
            this.actionConfiguration = actionConfiguration != null ? actionConfiguration.build() : null;
        }

        public final PipelineContext.Builder getPipelineContext() {
            return this.pipelineContext != null ? this.pipelineContext.toBuilder() : null;
        }

        @Override
        public final Builder pipelineContext(PipelineContext pipelineContext) {
            this.pipelineContext = pipelineContext;
            return this;
        }

        public final void setPipelineContext(PipelineContext.BuilderImpl pipelineContext) {
            this.pipelineContext = pipelineContext != null ? pipelineContext.build() : null;
        }

        public final Collection<Artifact.Builder> getInputArtifacts() {
            if (this.inputArtifacts instanceof SdkAutoConstructList) {
                return null;
            }
            return this.inputArtifacts != null ? (Collection)this.inputArtifacts.stream().map(Artifact::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder inputArtifacts(Collection<Artifact> inputArtifacts) {
            this.inputArtifacts = ArtifactListCopier.copy(inputArtifacts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputArtifacts(Artifact ... inputArtifacts) {
            this.inputArtifacts(Arrays.asList(inputArtifacts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputArtifacts(Consumer<Artifact.Builder> ... inputArtifacts) {
            this.inputArtifacts(Stream.of(inputArtifacts).map(c -> (Artifact)((Artifact.Builder)Artifact.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setInputArtifacts(Collection<Artifact.BuilderImpl> inputArtifacts) {
            this.inputArtifacts = ArtifactListCopier.copyFromBuilder(inputArtifacts);
        }

        public final Collection<Artifact.Builder> getOutputArtifacts() {
            if (this.outputArtifacts instanceof SdkAutoConstructList) {
                return null;
            }
            return this.outputArtifacts != null ? (Collection)this.outputArtifacts.stream().map(Artifact::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder outputArtifacts(Collection<Artifact> outputArtifacts) {
            this.outputArtifacts = ArtifactListCopier.copy(outputArtifacts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputArtifacts(Artifact ... outputArtifacts) {
            this.outputArtifacts(Arrays.asList(outputArtifacts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputArtifacts(Consumer<Artifact.Builder> ... outputArtifacts) {
            this.outputArtifacts(Stream.of(outputArtifacts).map(c -> (Artifact)((Artifact.Builder)Artifact.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setOutputArtifacts(Collection<Artifact.BuilderImpl> outputArtifacts) {
            this.outputArtifacts = ArtifactListCopier.copyFromBuilder(outputArtifacts);
        }

        public final AWSSessionCredentials.Builder getArtifactCredentials() {
            return this.artifactCredentials != null ? this.artifactCredentials.toBuilder() : null;
        }

        @Override
        public final Builder artifactCredentials(AWSSessionCredentials artifactCredentials) {
            this.artifactCredentials = artifactCredentials;
            return this;
        }

        public final void setArtifactCredentials(AWSSessionCredentials.BuilderImpl artifactCredentials) {
            this.artifactCredentials = artifactCredentials != null ? artifactCredentials.build() : null;
        }

        public final String getContinuationToken() {
            return this.continuationToken;
        }

        @Override
        public final Builder continuationToken(String continuationToken) {
            this.continuationToken = continuationToken;
            return this;
        }

        public final void setContinuationToken(String continuationToken) {
            this.continuationToken = continuationToken;
        }

        public final EncryptionKey.Builder getEncryptionKey() {
            return this.encryptionKey != null ? this.encryptionKey.toBuilder() : null;
        }

        @Override
        public final Builder encryptionKey(EncryptionKey encryptionKey) {
            this.encryptionKey = encryptionKey;
            return this;
        }

        public final void setEncryptionKey(EncryptionKey.BuilderImpl encryptionKey) {
            this.encryptionKey = encryptionKey != null ? encryptionKey.build() : null;
        }

        public JobData build() {
            return new JobData(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, JobData> {
        public Builder actionTypeId(ActionTypeId var1);

        default public Builder actionTypeId(Consumer<ActionTypeId.Builder> actionTypeId) {
            return this.actionTypeId((ActionTypeId)((ActionTypeId.Builder)ActionTypeId.builder().applyMutation(actionTypeId)).build());
        }

        public Builder actionConfiguration(ActionConfiguration var1);

        default public Builder actionConfiguration(Consumer<ActionConfiguration.Builder> actionConfiguration) {
            return this.actionConfiguration((ActionConfiguration)((ActionConfiguration.Builder)ActionConfiguration.builder().applyMutation(actionConfiguration)).build());
        }

        public Builder pipelineContext(PipelineContext var1);

        default public Builder pipelineContext(Consumer<PipelineContext.Builder> pipelineContext) {
            return this.pipelineContext((PipelineContext)((PipelineContext.Builder)PipelineContext.builder().applyMutation(pipelineContext)).build());
        }

        public Builder inputArtifacts(Collection<Artifact> var1);

        public Builder inputArtifacts(Artifact ... var1);

        public Builder inputArtifacts(Consumer<Artifact.Builder> ... var1);

        public Builder outputArtifacts(Collection<Artifact> var1);

        public Builder outputArtifacts(Artifact ... var1);

        public Builder outputArtifacts(Consumer<Artifact.Builder> ... var1);

        public Builder artifactCredentials(AWSSessionCredentials var1);

        default public Builder artifactCredentials(Consumer<AWSSessionCredentials.Builder> artifactCredentials) {
            return this.artifactCredentials((AWSSessionCredentials)((AWSSessionCredentials.Builder)AWSSessionCredentials.builder().applyMutation(artifactCredentials)).build());
        }

        public Builder continuationToken(String var1);

        public Builder encryptionKey(EncryptionKey var1);

        default public Builder encryptionKey(Consumer<EncryptionKey.Builder> encryptionKey) {
            return this.encryptionKey((EncryptionKey)((EncryptionKey.Builder)EncryptionKey.builder().applyMutation(encryptionKey)).build());
        }
    }
}

