/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.codepipeline.CodePipelineClient;
import software.amazon.awssdk.services.codepipeline.model.AcknowledgeJobRequest;
import software.amazon.awssdk.services.codepipeline.model.AcknowledgeJobResponse;
import software.amazon.awssdk.services.codepipeline.model.AcknowledgeThirdPartyJobRequest;
import software.amazon.awssdk.services.codepipeline.model.AcknowledgeThirdPartyJobResponse;
import software.amazon.awssdk.services.codepipeline.model.ActionNotFoundException;
import software.amazon.awssdk.services.codepipeline.model.ActionTypeNotFoundException;
import software.amazon.awssdk.services.codepipeline.model.ApprovalAlreadyCompletedException;
import software.amazon.awssdk.services.codepipeline.model.CodePipelineException;
import software.amazon.awssdk.services.codepipeline.model.CodePipelineRequest;
import software.amazon.awssdk.services.codepipeline.model.ConcurrentModificationException;
import software.amazon.awssdk.services.codepipeline.model.CreateCustomActionTypeRequest;
import software.amazon.awssdk.services.codepipeline.model.CreateCustomActionTypeResponse;
import software.amazon.awssdk.services.codepipeline.model.CreatePipelineRequest;
import software.amazon.awssdk.services.codepipeline.model.CreatePipelineResponse;
import software.amazon.awssdk.services.codepipeline.model.DeleteCustomActionTypeRequest;
import software.amazon.awssdk.services.codepipeline.model.DeleteCustomActionTypeResponse;
import software.amazon.awssdk.services.codepipeline.model.DeletePipelineRequest;
import software.amazon.awssdk.services.codepipeline.model.DeletePipelineResponse;
import software.amazon.awssdk.services.codepipeline.model.DeleteWebhookRequest;
import software.amazon.awssdk.services.codepipeline.model.DeleteWebhookResponse;
import software.amazon.awssdk.services.codepipeline.model.DeregisterWebhookWithThirdPartyRequest;
import software.amazon.awssdk.services.codepipeline.model.DeregisterWebhookWithThirdPartyResponse;
import software.amazon.awssdk.services.codepipeline.model.DisableStageTransitionRequest;
import software.amazon.awssdk.services.codepipeline.model.DisableStageTransitionResponse;
import software.amazon.awssdk.services.codepipeline.model.DuplicatedStopRequestException;
import software.amazon.awssdk.services.codepipeline.model.EnableStageTransitionRequest;
import software.amazon.awssdk.services.codepipeline.model.EnableStageTransitionResponse;
import software.amazon.awssdk.services.codepipeline.model.GetJobDetailsRequest;
import software.amazon.awssdk.services.codepipeline.model.GetJobDetailsResponse;
import software.amazon.awssdk.services.codepipeline.model.GetPipelineExecutionRequest;
import software.amazon.awssdk.services.codepipeline.model.GetPipelineExecutionResponse;
import software.amazon.awssdk.services.codepipeline.model.GetPipelineRequest;
import software.amazon.awssdk.services.codepipeline.model.GetPipelineResponse;
import software.amazon.awssdk.services.codepipeline.model.GetPipelineStateRequest;
import software.amazon.awssdk.services.codepipeline.model.GetPipelineStateResponse;
import software.amazon.awssdk.services.codepipeline.model.GetThirdPartyJobDetailsRequest;
import software.amazon.awssdk.services.codepipeline.model.GetThirdPartyJobDetailsResponse;
import software.amazon.awssdk.services.codepipeline.model.InvalidActionDeclarationException;
import software.amazon.awssdk.services.codepipeline.model.InvalidApprovalTokenException;
import software.amazon.awssdk.services.codepipeline.model.InvalidArnException;
import software.amazon.awssdk.services.codepipeline.model.InvalidBlockerDeclarationException;
import software.amazon.awssdk.services.codepipeline.model.InvalidClientTokenException;
import software.amazon.awssdk.services.codepipeline.model.InvalidJobException;
import software.amazon.awssdk.services.codepipeline.model.InvalidJobStateException;
import software.amazon.awssdk.services.codepipeline.model.InvalidNextTokenException;
import software.amazon.awssdk.services.codepipeline.model.InvalidNonceException;
import software.amazon.awssdk.services.codepipeline.model.InvalidStageDeclarationException;
import software.amazon.awssdk.services.codepipeline.model.InvalidStructureException;
import software.amazon.awssdk.services.codepipeline.model.InvalidTagsException;
import software.amazon.awssdk.services.codepipeline.model.InvalidWebhookAuthenticationParametersException;
import software.amazon.awssdk.services.codepipeline.model.InvalidWebhookFilterPatternException;
import software.amazon.awssdk.services.codepipeline.model.JobNotFoundException;
import software.amazon.awssdk.services.codepipeline.model.LimitExceededException;
import software.amazon.awssdk.services.codepipeline.model.ListActionExecutionsRequest;
import software.amazon.awssdk.services.codepipeline.model.ListActionExecutionsResponse;
import software.amazon.awssdk.services.codepipeline.model.ListActionTypesRequest;
import software.amazon.awssdk.services.codepipeline.model.ListActionTypesResponse;
import software.amazon.awssdk.services.codepipeline.model.ListPipelineExecutionsRequest;
import software.amazon.awssdk.services.codepipeline.model.ListPipelineExecutionsResponse;
import software.amazon.awssdk.services.codepipeline.model.ListPipelinesRequest;
import software.amazon.awssdk.services.codepipeline.model.ListPipelinesResponse;
import software.amazon.awssdk.services.codepipeline.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.codepipeline.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.codepipeline.model.ListWebhooksRequest;
import software.amazon.awssdk.services.codepipeline.model.ListWebhooksResponse;
import software.amazon.awssdk.services.codepipeline.model.NotLatestPipelineExecutionException;
import software.amazon.awssdk.services.codepipeline.model.OutputVariablesSizeExceededException;
import software.amazon.awssdk.services.codepipeline.model.PipelineExecutionNotFoundException;
import software.amazon.awssdk.services.codepipeline.model.PipelineExecutionNotStoppableException;
import software.amazon.awssdk.services.codepipeline.model.PipelineNameInUseException;
import software.amazon.awssdk.services.codepipeline.model.PipelineNotFoundException;
import software.amazon.awssdk.services.codepipeline.model.PipelineVersionNotFoundException;
import software.amazon.awssdk.services.codepipeline.model.PollForJobsRequest;
import software.amazon.awssdk.services.codepipeline.model.PollForJobsResponse;
import software.amazon.awssdk.services.codepipeline.model.PollForThirdPartyJobsRequest;
import software.amazon.awssdk.services.codepipeline.model.PollForThirdPartyJobsResponse;
import software.amazon.awssdk.services.codepipeline.model.PutActionRevisionRequest;
import software.amazon.awssdk.services.codepipeline.model.PutActionRevisionResponse;
import software.amazon.awssdk.services.codepipeline.model.PutApprovalResultRequest;
import software.amazon.awssdk.services.codepipeline.model.PutApprovalResultResponse;
import software.amazon.awssdk.services.codepipeline.model.PutJobFailureResultRequest;
import software.amazon.awssdk.services.codepipeline.model.PutJobFailureResultResponse;
import software.amazon.awssdk.services.codepipeline.model.PutJobSuccessResultRequest;
import software.amazon.awssdk.services.codepipeline.model.PutJobSuccessResultResponse;
import software.amazon.awssdk.services.codepipeline.model.PutThirdPartyJobFailureResultRequest;
import software.amazon.awssdk.services.codepipeline.model.PutThirdPartyJobFailureResultResponse;
import software.amazon.awssdk.services.codepipeline.model.PutThirdPartyJobSuccessResultRequest;
import software.amazon.awssdk.services.codepipeline.model.PutThirdPartyJobSuccessResultResponse;
import software.amazon.awssdk.services.codepipeline.model.PutWebhookRequest;
import software.amazon.awssdk.services.codepipeline.model.PutWebhookResponse;
import software.amazon.awssdk.services.codepipeline.model.RegisterWebhookWithThirdPartyRequest;
import software.amazon.awssdk.services.codepipeline.model.RegisterWebhookWithThirdPartyResponse;
import software.amazon.awssdk.services.codepipeline.model.ResourceNotFoundException;
import software.amazon.awssdk.services.codepipeline.model.RetryStageExecutionRequest;
import software.amazon.awssdk.services.codepipeline.model.RetryStageExecutionResponse;
import software.amazon.awssdk.services.codepipeline.model.StageNotFoundException;
import software.amazon.awssdk.services.codepipeline.model.StageNotRetryableException;
import software.amazon.awssdk.services.codepipeline.model.StartPipelineExecutionRequest;
import software.amazon.awssdk.services.codepipeline.model.StartPipelineExecutionResponse;
import software.amazon.awssdk.services.codepipeline.model.StopPipelineExecutionRequest;
import software.amazon.awssdk.services.codepipeline.model.StopPipelineExecutionResponse;
import software.amazon.awssdk.services.codepipeline.model.TagResourceRequest;
import software.amazon.awssdk.services.codepipeline.model.TagResourceResponse;
import software.amazon.awssdk.services.codepipeline.model.TooManyTagsException;
import software.amazon.awssdk.services.codepipeline.model.UntagResourceRequest;
import software.amazon.awssdk.services.codepipeline.model.UntagResourceResponse;
import software.amazon.awssdk.services.codepipeline.model.UpdatePipelineRequest;
import software.amazon.awssdk.services.codepipeline.model.UpdatePipelineResponse;
import software.amazon.awssdk.services.codepipeline.model.ValidationException;
import software.amazon.awssdk.services.codepipeline.model.WebhookNotFoundException;
import software.amazon.awssdk.services.codepipeline.paginators.ListActionExecutionsIterable;
import software.amazon.awssdk.services.codepipeline.paginators.ListActionTypesIterable;
import software.amazon.awssdk.services.codepipeline.paginators.ListPipelineExecutionsIterable;
import software.amazon.awssdk.services.codepipeline.paginators.ListPipelinesIterable;
import software.amazon.awssdk.services.codepipeline.paginators.ListTagsForResourceIterable;
import software.amazon.awssdk.services.codepipeline.paginators.ListWebhooksIterable;
import software.amazon.awssdk.services.codepipeline.transform.AcknowledgeJobRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.AcknowledgeThirdPartyJobRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.CreateCustomActionTypeRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.CreatePipelineRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.DeleteCustomActionTypeRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.DeletePipelineRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.DeleteWebhookRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.DeregisterWebhookWithThirdPartyRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.DisableStageTransitionRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.EnableStageTransitionRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.GetJobDetailsRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.GetPipelineExecutionRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.GetPipelineRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.GetPipelineStateRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.GetThirdPartyJobDetailsRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.ListActionExecutionsRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.ListActionTypesRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.ListPipelineExecutionsRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.ListPipelinesRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.ListWebhooksRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.PollForJobsRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.PollForThirdPartyJobsRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.PutActionRevisionRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.PutApprovalResultRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.PutJobFailureResultRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.PutJobSuccessResultRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.PutThirdPartyJobFailureResultRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.PutThirdPartyJobSuccessResultRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.PutWebhookRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.RegisterWebhookWithThirdPartyRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.RetryStageExecutionRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.StartPipelineExecutionRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.StopPipelineExecutionRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.UpdatePipelineRequestMarshaller;

@SdkInternalApi
final class DefaultCodePipelineClient
implements CodePipelineClient {
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultCodePipelineClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    public final String serviceName() {
        return "codepipeline";
    }

    @Override
    public AcknowledgeJobResponse acknowledgeJob(AcknowledgeJobRequest acknowledgeJobRequest) throws ValidationException, InvalidNonceException, JobNotFoundException, AwsServiceException, SdkClientException, CodePipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AcknowledgeJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (AcknowledgeJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AcknowledgeJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)acknowledgeJobRequest).withMarshaller((Marshaller)new AcknowledgeJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public AcknowledgeThirdPartyJobResponse acknowledgeThirdPartyJob(AcknowledgeThirdPartyJobRequest acknowledgeThirdPartyJobRequest) throws ValidationException, InvalidNonceException, JobNotFoundException, InvalidClientTokenException, AwsServiceException, SdkClientException, CodePipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AcknowledgeThirdPartyJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (AcknowledgeThirdPartyJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AcknowledgeThirdPartyJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)acknowledgeThirdPartyJobRequest).withMarshaller((Marshaller)new AcknowledgeThirdPartyJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public CreateCustomActionTypeResponse createCustomActionType(CreateCustomActionTypeRequest createCustomActionTypeRequest) throws ValidationException, LimitExceededException, TooManyTagsException, InvalidTagsException, ConcurrentModificationException, AwsServiceException, SdkClientException, CodePipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateCustomActionTypeResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CreateCustomActionTypeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateCustomActionType").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createCustomActionTypeRequest).withMarshaller((Marshaller)new CreateCustomActionTypeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public CreatePipelineResponse createPipeline(CreatePipelineRequest createPipelineRequest) throws ValidationException, PipelineNameInUseException, InvalidStageDeclarationException, InvalidActionDeclarationException, InvalidBlockerDeclarationException, InvalidStructureException, LimitExceededException, TooManyTagsException, InvalidTagsException, ConcurrentModificationException, AwsServiceException, SdkClientException, CodePipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreatePipelineResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CreatePipelineResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreatePipeline").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createPipelineRequest).withMarshaller((Marshaller)new CreatePipelineRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteCustomActionTypeResponse deleteCustomActionType(DeleteCustomActionTypeRequest deleteCustomActionTypeRequest) throws ValidationException, ConcurrentModificationException, AwsServiceException, SdkClientException, CodePipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteCustomActionTypeResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeleteCustomActionTypeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteCustomActionType").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteCustomActionTypeRequest).withMarshaller((Marshaller)new DeleteCustomActionTypeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeletePipelineResponse deletePipeline(DeletePipelineRequest deletePipelineRequest) throws ValidationException, ConcurrentModificationException, AwsServiceException, SdkClientException, CodePipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeletePipelineResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeletePipelineResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeletePipeline").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deletePipelineRequest).withMarshaller((Marshaller)new DeletePipelineRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteWebhookResponse deleteWebhook(DeleteWebhookRequest deleteWebhookRequest) throws ValidationException, ConcurrentModificationException, AwsServiceException, SdkClientException, CodePipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteWebhookResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeleteWebhookResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteWebhook").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteWebhookRequest).withMarshaller((Marshaller)new DeleteWebhookRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeregisterWebhookWithThirdPartyResponse deregisterWebhookWithThirdParty(DeregisterWebhookWithThirdPartyRequest deregisterWebhookWithThirdPartyRequest) throws ValidationException, WebhookNotFoundException, AwsServiceException, SdkClientException, CodePipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeregisterWebhookWithThirdPartyResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeregisterWebhookWithThirdPartyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeregisterWebhookWithThirdParty").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deregisterWebhookWithThirdPartyRequest).withMarshaller((Marshaller)new DeregisterWebhookWithThirdPartyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DisableStageTransitionResponse disableStageTransition(DisableStageTransitionRequest disableStageTransitionRequest) throws ValidationException, PipelineNotFoundException, StageNotFoundException, AwsServiceException, SdkClientException, CodePipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisableStageTransitionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DisableStageTransitionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisableStageTransition").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)disableStageTransitionRequest).withMarshaller((Marshaller)new DisableStageTransitionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public EnableStageTransitionResponse enableStageTransition(EnableStageTransitionRequest enableStageTransitionRequest) throws ValidationException, PipelineNotFoundException, StageNotFoundException, AwsServiceException, SdkClientException, CodePipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, EnableStageTransitionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (EnableStageTransitionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("EnableStageTransition").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)enableStageTransitionRequest).withMarshaller((Marshaller)new EnableStageTransitionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetJobDetailsResponse getJobDetails(GetJobDetailsRequest getJobDetailsRequest) throws ValidationException, JobNotFoundException, AwsServiceException, SdkClientException, CodePipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetJobDetailsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (GetJobDetailsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetJobDetails").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getJobDetailsRequest).withMarshaller((Marshaller)new GetJobDetailsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetPipelineResponse getPipeline(GetPipelineRequest getPipelineRequest) throws ValidationException, PipelineNotFoundException, PipelineVersionNotFoundException, AwsServiceException, SdkClientException, CodePipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetPipelineResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (GetPipelineResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetPipeline").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getPipelineRequest).withMarshaller((Marshaller)new GetPipelineRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetPipelineExecutionResponse getPipelineExecution(GetPipelineExecutionRequest getPipelineExecutionRequest) throws ValidationException, PipelineNotFoundException, PipelineExecutionNotFoundException, AwsServiceException, SdkClientException, CodePipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetPipelineExecutionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (GetPipelineExecutionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetPipelineExecution").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getPipelineExecutionRequest).withMarshaller((Marshaller)new GetPipelineExecutionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetPipelineStateResponse getPipelineState(GetPipelineStateRequest getPipelineStateRequest) throws ValidationException, PipelineNotFoundException, AwsServiceException, SdkClientException, CodePipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetPipelineStateResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (GetPipelineStateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetPipelineState").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getPipelineStateRequest).withMarshaller((Marshaller)new GetPipelineStateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetThirdPartyJobDetailsResponse getThirdPartyJobDetails(GetThirdPartyJobDetailsRequest getThirdPartyJobDetailsRequest) throws JobNotFoundException, ValidationException, InvalidClientTokenException, InvalidJobException, AwsServiceException, SdkClientException, CodePipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetThirdPartyJobDetailsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (GetThirdPartyJobDetailsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetThirdPartyJobDetails").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getThirdPartyJobDetailsRequest).withMarshaller((Marshaller)new GetThirdPartyJobDetailsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListActionExecutionsResponse listActionExecutions(ListActionExecutionsRequest listActionExecutionsRequest) throws ValidationException, PipelineNotFoundException, InvalidNextTokenException, PipelineExecutionNotFoundException, AwsServiceException, SdkClientException, CodePipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListActionExecutionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListActionExecutionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListActionExecutions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listActionExecutionsRequest).withMarshaller((Marshaller)new ListActionExecutionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListActionExecutionsIterable listActionExecutionsPaginator(ListActionExecutionsRequest listActionExecutionsRequest) throws ValidationException, PipelineNotFoundException, InvalidNextTokenException, PipelineExecutionNotFoundException, AwsServiceException, SdkClientException, CodePipelineException {
        return new ListActionExecutionsIterable(this, this.applyPaginatorUserAgent(listActionExecutionsRequest));
    }

    @Override
    public ListActionTypesResponse listActionTypes(ListActionTypesRequest listActionTypesRequest) throws ValidationException, InvalidNextTokenException, AwsServiceException, SdkClientException, CodePipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListActionTypesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListActionTypesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListActionTypes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listActionTypesRequest).withMarshaller((Marshaller)new ListActionTypesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListActionTypesIterable listActionTypesPaginator(ListActionTypesRequest listActionTypesRequest) throws ValidationException, InvalidNextTokenException, AwsServiceException, SdkClientException, CodePipelineException {
        return new ListActionTypesIterable(this, this.applyPaginatorUserAgent(listActionTypesRequest));
    }

    @Override
    public ListPipelineExecutionsResponse listPipelineExecutions(ListPipelineExecutionsRequest listPipelineExecutionsRequest) throws ValidationException, PipelineNotFoundException, InvalidNextTokenException, AwsServiceException, SdkClientException, CodePipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListPipelineExecutionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListPipelineExecutionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListPipelineExecutions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listPipelineExecutionsRequest).withMarshaller((Marshaller)new ListPipelineExecutionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListPipelineExecutionsIterable listPipelineExecutionsPaginator(ListPipelineExecutionsRequest listPipelineExecutionsRequest) throws ValidationException, PipelineNotFoundException, InvalidNextTokenException, AwsServiceException, SdkClientException, CodePipelineException {
        return new ListPipelineExecutionsIterable(this, this.applyPaginatorUserAgent(listPipelineExecutionsRequest));
    }

    @Override
    public ListPipelinesResponse listPipelines(ListPipelinesRequest listPipelinesRequest) throws ValidationException, InvalidNextTokenException, AwsServiceException, SdkClientException, CodePipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListPipelinesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListPipelinesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListPipelines").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listPipelinesRequest).withMarshaller((Marshaller)new ListPipelinesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListPipelinesIterable listPipelinesPaginator(ListPipelinesRequest listPipelinesRequest) throws ValidationException, InvalidNextTokenException, AwsServiceException, SdkClientException, CodePipelineException {
        return new ListPipelinesIterable(this, this.applyPaginatorUserAgent(listPipelinesRequest));
    }

    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws ValidationException, ResourceNotFoundException, InvalidNextTokenException, InvalidArnException, AwsServiceException, SdkClientException, CodePipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTagsForResourceRequest).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListTagsForResourceIterable listTagsForResourcePaginator(ListTagsForResourceRequest listTagsForResourceRequest) throws ValidationException, ResourceNotFoundException, InvalidNextTokenException, InvalidArnException, AwsServiceException, SdkClientException, CodePipelineException {
        return new ListTagsForResourceIterable(this, this.applyPaginatorUserAgent(listTagsForResourceRequest));
    }

    @Override
    public ListWebhooksResponse listWebhooks(ListWebhooksRequest listWebhooksRequest) throws ValidationException, InvalidNextTokenException, AwsServiceException, SdkClientException, CodePipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListWebhooksResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListWebhooksResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListWebhooks").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listWebhooksRequest).withMarshaller((Marshaller)new ListWebhooksRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListWebhooksIterable listWebhooksPaginator(ListWebhooksRequest listWebhooksRequest) throws ValidationException, InvalidNextTokenException, AwsServiceException, SdkClientException, CodePipelineException {
        return new ListWebhooksIterable(this, this.applyPaginatorUserAgent(listWebhooksRequest));
    }

    @Override
    public PollForJobsResponse pollForJobs(PollForJobsRequest pollForJobsRequest) throws ValidationException, ActionTypeNotFoundException, AwsServiceException, SdkClientException, CodePipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PollForJobsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (PollForJobsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PollForJobs").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)pollForJobsRequest).withMarshaller((Marshaller)new PollForJobsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public PollForThirdPartyJobsResponse pollForThirdPartyJobs(PollForThirdPartyJobsRequest pollForThirdPartyJobsRequest) throws ActionTypeNotFoundException, ValidationException, AwsServiceException, SdkClientException, CodePipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PollForThirdPartyJobsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (PollForThirdPartyJobsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PollForThirdPartyJobs").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)pollForThirdPartyJobsRequest).withMarshaller((Marshaller)new PollForThirdPartyJobsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public PutActionRevisionResponse putActionRevision(PutActionRevisionRequest putActionRevisionRequest) throws PipelineNotFoundException, StageNotFoundException, ActionNotFoundException, ValidationException, AwsServiceException, SdkClientException, CodePipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutActionRevisionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (PutActionRevisionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutActionRevision").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putActionRevisionRequest).withMarshaller((Marshaller)new PutActionRevisionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public PutApprovalResultResponse putApprovalResult(PutApprovalResultRequest putApprovalResultRequest) throws InvalidApprovalTokenException, ApprovalAlreadyCompletedException, PipelineNotFoundException, StageNotFoundException, ActionNotFoundException, ValidationException, AwsServiceException, SdkClientException, CodePipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutApprovalResultResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (PutApprovalResultResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutApprovalResult").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putApprovalResultRequest).withMarshaller((Marshaller)new PutApprovalResultRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public PutJobFailureResultResponse putJobFailureResult(PutJobFailureResultRequest putJobFailureResultRequest) throws ValidationException, JobNotFoundException, InvalidJobStateException, AwsServiceException, SdkClientException, CodePipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutJobFailureResultResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (PutJobFailureResultResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutJobFailureResult").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putJobFailureResultRequest).withMarshaller((Marshaller)new PutJobFailureResultRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public PutJobSuccessResultResponse putJobSuccessResult(PutJobSuccessResultRequest putJobSuccessResultRequest) throws ValidationException, JobNotFoundException, InvalidJobStateException, OutputVariablesSizeExceededException, AwsServiceException, SdkClientException, CodePipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutJobSuccessResultResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (PutJobSuccessResultResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutJobSuccessResult").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putJobSuccessResultRequest).withMarshaller((Marshaller)new PutJobSuccessResultRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public PutThirdPartyJobFailureResultResponse putThirdPartyJobFailureResult(PutThirdPartyJobFailureResultRequest putThirdPartyJobFailureResultRequest) throws ValidationException, JobNotFoundException, InvalidJobStateException, InvalidClientTokenException, AwsServiceException, SdkClientException, CodePipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutThirdPartyJobFailureResultResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (PutThirdPartyJobFailureResultResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutThirdPartyJobFailureResult").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putThirdPartyJobFailureResultRequest).withMarshaller((Marshaller)new PutThirdPartyJobFailureResultRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public PutThirdPartyJobSuccessResultResponse putThirdPartyJobSuccessResult(PutThirdPartyJobSuccessResultRequest putThirdPartyJobSuccessResultRequest) throws ValidationException, JobNotFoundException, InvalidJobStateException, InvalidClientTokenException, AwsServiceException, SdkClientException, CodePipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutThirdPartyJobSuccessResultResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (PutThirdPartyJobSuccessResultResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutThirdPartyJobSuccessResult").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putThirdPartyJobSuccessResultRequest).withMarshaller((Marshaller)new PutThirdPartyJobSuccessResultRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public PutWebhookResponse putWebhook(PutWebhookRequest putWebhookRequest) throws ValidationException, LimitExceededException, InvalidWebhookFilterPatternException, InvalidWebhookAuthenticationParametersException, PipelineNotFoundException, TooManyTagsException, InvalidTagsException, ConcurrentModificationException, AwsServiceException, SdkClientException, CodePipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutWebhookResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (PutWebhookResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutWebhook").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putWebhookRequest).withMarshaller((Marshaller)new PutWebhookRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public RegisterWebhookWithThirdPartyResponse registerWebhookWithThirdParty(RegisterWebhookWithThirdPartyRequest registerWebhookWithThirdPartyRequest) throws ValidationException, WebhookNotFoundException, AwsServiceException, SdkClientException, CodePipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RegisterWebhookWithThirdPartyResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (RegisterWebhookWithThirdPartyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RegisterWebhookWithThirdParty").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)registerWebhookWithThirdPartyRequest).withMarshaller((Marshaller)new RegisterWebhookWithThirdPartyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public RetryStageExecutionResponse retryStageExecution(RetryStageExecutionRequest retryStageExecutionRequest) throws ValidationException, PipelineNotFoundException, StageNotFoundException, StageNotRetryableException, NotLatestPipelineExecutionException, AwsServiceException, SdkClientException, CodePipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RetryStageExecutionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (RetryStageExecutionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RetryStageExecution").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)retryStageExecutionRequest).withMarshaller((Marshaller)new RetryStageExecutionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public StartPipelineExecutionResponse startPipelineExecution(StartPipelineExecutionRequest startPipelineExecutionRequest) throws ValidationException, PipelineNotFoundException, AwsServiceException, SdkClientException, CodePipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartPipelineExecutionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (StartPipelineExecutionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartPipelineExecution").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)startPipelineExecutionRequest).withMarshaller((Marshaller)new StartPipelineExecutionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public StopPipelineExecutionResponse stopPipelineExecution(StopPipelineExecutionRequest stopPipelineExecutionRequest) throws ValidationException, PipelineNotFoundException, PipelineExecutionNotStoppableException, DuplicatedStopRequestException, AwsServiceException, SdkClientException, CodePipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopPipelineExecutionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (StopPipelineExecutionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopPipelineExecution").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)stopPipelineExecutionRequest).withMarshaller((Marshaller)new StopPipelineExecutionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ValidationException, ResourceNotFoundException, InvalidArnException, TooManyTagsException, InvalidTagsException, ConcurrentModificationException, AwsServiceException, SdkClientException, CodePipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)tagResourceRequest).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ValidationException, ResourceNotFoundException, InvalidArnException, InvalidTagsException, ConcurrentModificationException, AwsServiceException, SdkClientException, CodePipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)untagResourceRequest).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public UpdatePipelineResponse updatePipeline(UpdatePipelineRequest updatePipelineRequest) throws ValidationException, InvalidStageDeclarationException, InvalidActionDeclarationException, InvalidBlockerDeclarationException, InvalidStructureException, LimitExceededException, AwsServiceException, SdkClientException, CodePipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdatePipelineResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (UpdatePipelineResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdatePipeline").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updatePipelineRequest).withMarshaller((Marshaller)new UpdatePipelineRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(CodePipelineException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").exceptionBuilderSupplier(InvalidClientTokenException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidJobStateException").exceptionBuilderSupplier(InvalidJobStateException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("PipelineVersionNotFoundException").exceptionBuilderSupplier(PipelineVersionNotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidWebhookFilterPatternException").exceptionBuilderSupplier(InvalidWebhookFilterPatternException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("OutputVariablesSizeExceededException").exceptionBuilderSupplier(OutputVariablesSizeExceededException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidWebhookAuthenticationParametersException").exceptionBuilderSupplier(InvalidWebhookAuthenticationParametersException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("WebhookNotFoundException").exceptionBuilderSupplier(WebhookNotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidApprovalTokenException").exceptionBuilderSupplier(InvalidApprovalTokenException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidActionDeclarationException").exceptionBuilderSupplier(InvalidActionDeclarationException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidArnException").exceptionBuilderSupplier(InvalidArnException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("PipelineExecutionNotFoundException").exceptionBuilderSupplier(PipelineExecutionNotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ApprovalAlreadyCompletedException").exceptionBuilderSupplier(ApprovalAlreadyCompletedException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("PipelineNameInUseException").exceptionBuilderSupplier(PipelineNameInUseException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("PipelineNotFoundException").exceptionBuilderSupplier(PipelineNotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").exceptionBuilderSupplier(InvalidNextTokenException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidJobException").exceptionBuilderSupplier(InvalidJobException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("LimitExceededException").exceptionBuilderSupplier(LimitExceededException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ActionTypeNotFoundException").exceptionBuilderSupplier(ActionTypeNotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("StageNotFoundException").exceptionBuilderSupplier(StageNotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("StageNotRetryableException").exceptionBuilderSupplier(StageNotRetryableException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyTagsException").exceptionBuilderSupplier(TooManyTagsException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidStructureException").exceptionBuilderSupplier(InvalidStructureException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DuplicatedStopRequestException").exceptionBuilderSupplier(DuplicatedStopRequestException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidBlockerDeclarationException").exceptionBuilderSupplier(InvalidBlockerDeclarationException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidTagsException").exceptionBuilderSupplier(InvalidTagsException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ActionNotFoundException").exceptionBuilderSupplier(ActionNotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidStageDeclarationException").exceptionBuilderSupplier(InvalidStageDeclarationException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ValidationException").exceptionBuilderSupplier(ValidationException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidNonceException").exceptionBuilderSupplier(InvalidNonceException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("JobNotFoundException").exceptionBuilderSupplier(JobNotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("PipelineExecutionNotStoppableException").exceptionBuilderSupplier(PipelineExecutionNotStoppableException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NotLatestPipelineExecutionException").exceptionBuilderSupplier(NotLatestPipelineExecutionException::builder).build());
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends CodePipelineRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.13.15").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((CodePipelineRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }
}

