/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codepipeline.model.ExecutionTrigger;
import software.amazon.awssdk.services.codepipeline.model.PipelineExecutionStatus;
import software.amazon.awssdk.services.codepipeline.model.SourceRevision;
import software.amazon.awssdk.services.codepipeline.model.SourceRevisionListCopier;
import software.amazon.awssdk.services.codepipeline.model.StopExecutionTrigger;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PipelineExecutionSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PipelineExecutionSummary> {
    private static final SdkField<String> PIPELINE_EXECUTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PipelineExecutionSummary.getter(PipelineExecutionSummary::pipelineExecutionId)).setter(PipelineExecutionSummary.setter(Builder::pipelineExecutionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipelineExecutionId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PipelineExecutionSummary.getter(PipelineExecutionSummary::statusAsString)).setter(PipelineExecutionSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(PipelineExecutionSummary.getter(PipelineExecutionSummary::startTime)).setter(PipelineExecutionSummary.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()}).build();
    private static final SdkField<Instant> LAST_UPDATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(PipelineExecutionSummary.getter(PipelineExecutionSummary::lastUpdateTime)).setter(PipelineExecutionSummary.setter(Builder::lastUpdateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdateTime").build()}).build();
    private static final SdkField<List<SourceRevision>> SOURCE_REVISIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(PipelineExecutionSummary.getter(PipelineExecutionSummary::sourceRevisions)).setter(PipelineExecutionSummary.setter(Builder::sourceRevisions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceRevisions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SourceRevision::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ExecutionTrigger> TRIGGER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(PipelineExecutionSummary.getter(PipelineExecutionSummary::trigger)).setter(PipelineExecutionSummary.setter(Builder::trigger)).constructor(ExecutionTrigger::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trigger").build()}).build();
    private static final SdkField<StopExecutionTrigger> STOP_TRIGGER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(PipelineExecutionSummary.getter(PipelineExecutionSummary::stopTrigger)).setter(PipelineExecutionSummary.setter(Builder::stopTrigger)).constructor(StopExecutionTrigger::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stopTrigger").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PIPELINE_EXECUTION_ID_FIELD, STATUS_FIELD, START_TIME_FIELD, LAST_UPDATE_TIME_FIELD, SOURCE_REVISIONS_FIELD, TRIGGER_FIELD, STOP_TRIGGER_FIELD));
    private static final long serialVersionUID = 1L;
    private final String pipelineExecutionId;
    private final String status;
    private final Instant startTime;
    private final Instant lastUpdateTime;
    private final List<SourceRevision> sourceRevisions;
    private final ExecutionTrigger trigger;
    private final StopExecutionTrigger stopTrigger;

    private PipelineExecutionSummary(BuilderImpl builder) {
        this.pipelineExecutionId = builder.pipelineExecutionId;
        this.status = builder.status;
        this.startTime = builder.startTime;
        this.lastUpdateTime = builder.lastUpdateTime;
        this.sourceRevisions = builder.sourceRevisions;
        this.trigger = builder.trigger;
        this.stopTrigger = builder.stopTrigger;
    }

    public String pipelineExecutionId() {
        return this.pipelineExecutionId;
    }

    public PipelineExecutionStatus status() {
        return PipelineExecutionStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public Instant startTime() {
        return this.startTime;
    }

    public Instant lastUpdateTime() {
        return this.lastUpdateTime;
    }

    public boolean hasSourceRevisions() {
        return this.sourceRevisions != null && !(this.sourceRevisions instanceof SdkAutoConstructList);
    }

    public List<SourceRevision> sourceRevisions() {
        return this.sourceRevisions;
    }

    public ExecutionTrigger trigger() {
        return this.trigger;
    }

    public StopExecutionTrigger stopTrigger() {
        return this.stopTrigger;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineExecutionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceRevisions());
        hashCode = 31 * hashCode + Objects.hashCode(this.trigger());
        hashCode = 31 * hashCode + Objects.hashCode(this.stopTrigger());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PipelineExecutionSummary)) {
            return false;
        }
        PipelineExecutionSummary other = (PipelineExecutionSummary)obj;
        return Objects.equals(this.pipelineExecutionId(), other.pipelineExecutionId()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.lastUpdateTime(), other.lastUpdateTime()) && Objects.equals(this.sourceRevisions(), other.sourceRevisions()) && Objects.equals(this.trigger(), other.trigger()) && Objects.equals(this.stopTrigger(), other.stopTrigger());
    }

    public String toString() {
        return ToString.builder((String)"PipelineExecutionSummary").add("PipelineExecutionId", (Object)this.pipelineExecutionId()).add("Status", (Object)this.statusAsString()).add("StartTime", (Object)this.startTime()).add("LastUpdateTime", (Object)this.lastUpdateTime()).add("SourceRevisions", this.sourceRevisions()).add("Trigger", (Object)this.trigger()).add("StopTrigger", (Object)this.stopTrigger()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "pipelineExecutionId": {
                return Optional.ofNullable(clazz.cast(this.pipelineExecutionId()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "startTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "lastUpdateTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdateTime()));
            }
            case "sourceRevisions": {
                return Optional.ofNullable(clazz.cast(this.sourceRevisions()));
            }
            case "trigger": {
                return Optional.ofNullable(clazz.cast(this.trigger()));
            }
            case "stopTrigger": {
                return Optional.ofNullable(clazz.cast(this.stopTrigger()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PipelineExecutionSummary, T> g) {
        return obj -> g.apply((PipelineExecutionSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String pipelineExecutionId;
        private String status;
        private Instant startTime;
        private Instant lastUpdateTime;
        private List<SourceRevision> sourceRevisions = DefaultSdkAutoConstructList.getInstance();
        private ExecutionTrigger trigger;
        private StopExecutionTrigger stopTrigger;

        private BuilderImpl() {
        }

        private BuilderImpl(PipelineExecutionSummary model) {
            this.pipelineExecutionId(model.pipelineExecutionId);
            this.status(model.status);
            this.startTime(model.startTime);
            this.lastUpdateTime(model.lastUpdateTime);
            this.sourceRevisions(model.sourceRevisions);
            this.trigger(model.trigger);
            this.stopTrigger(model.stopTrigger);
        }

        public final String getPipelineExecutionId() {
            return this.pipelineExecutionId;
        }

        @Override
        public final Builder pipelineExecutionId(String pipelineExecutionId) {
            this.pipelineExecutionId = pipelineExecutionId;
            return this;
        }

        public final void setPipelineExecutionId(String pipelineExecutionId) {
            this.pipelineExecutionId = pipelineExecutionId;
        }

        public final String getStatusAsString() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(PipelineExecutionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getLastUpdateTime() {
            return this.lastUpdateTime;
        }

        @Override
        public final Builder lastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return this;
        }

        public final void setLastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
        }

        public final Collection<SourceRevision.Builder> getSourceRevisions() {
            return this.sourceRevisions != null ? (Collection)this.sourceRevisions.stream().map(SourceRevision::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder sourceRevisions(Collection<SourceRevision> sourceRevisions) {
            this.sourceRevisions = SourceRevisionListCopier.copy(sourceRevisions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceRevisions(SourceRevision ... sourceRevisions) {
            this.sourceRevisions(Arrays.asList(sourceRevisions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceRevisions(Consumer<SourceRevision.Builder> ... sourceRevisions) {
            this.sourceRevisions(Stream.of(sourceRevisions).map(c -> (SourceRevision)((SourceRevision.Builder)SourceRevision.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSourceRevisions(Collection<SourceRevision.BuilderImpl> sourceRevisions) {
            this.sourceRevisions = SourceRevisionListCopier.copyFromBuilder(sourceRevisions);
        }

        public final ExecutionTrigger.Builder getTrigger() {
            return this.trigger != null ? this.trigger.toBuilder() : null;
        }

        @Override
        public final Builder trigger(ExecutionTrigger trigger) {
            this.trigger = trigger;
            return this;
        }

        public final void setTrigger(ExecutionTrigger.BuilderImpl trigger) {
            this.trigger = trigger != null ? trigger.build() : null;
        }

        public final StopExecutionTrigger.Builder getStopTrigger() {
            return this.stopTrigger != null ? this.stopTrigger.toBuilder() : null;
        }

        @Override
        public final Builder stopTrigger(StopExecutionTrigger stopTrigger) {
            this.stopTrigger = stopTrigger;
            return this;
        }

        public final void setStopTrigger(StopExecutionTrigger.BuilderImpl stopTrigger) {
            this.stopTrigger = stopTrigger != null ? stopTrigger.build() : null;
        }

        public PipelineExecutionSummary build() {
            return new PipelineExecutionSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PipelineExecutionSummary> {
        public Builder pipelineExecutionId(String var1);

        public Builder status(String var1);

        public Builder status(PipelineExecutionStatus var1);

        public Builder startTime(Instant var1);

        public Builder lastUpdateTime(Instant var1);

        public Builder sourceRevisions(Collection<SourceRevision> var1);

        public Builder sourceRevisions(SourceRevision ... var1);

        public Builder sourceRevisions(Consumer<SourceRevision.Builder> ... var1);

        public Builder trigger(ExecutionTrigger var1);

        default public Builder trigger(Consumer<ExecutionTrigger.Builder> trigger) {
            return this.trigger((ExecutionTrigger)((ExecutionTrigger.Builder)ExecutionTrigger.builder().applyMutation(trigger)).build());
        }

        public Builder stopTrigger(StopExecutionTrigger var1);

        default public Builder stopTrigger(Consumer<StopExecutionTrigger.Builder> stopTrigger) {
            return this.stopTrigger((StopExecutionTrigger)((StopExecutionTrigger.Builder)StopExecutionTrigger.builder().applyMutation(stopTrigger)).build());
        }
    }
}

