/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.codepipeline.model.TransitionState;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class TransitionStateMarshaller {
    private static final MarshallingInfo<Boolean> ENABLED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("enabled").isBinary(false).build();
    private static final MarshallingInfo<String> LASTCHANGEDBY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastChangedBy").isBinary(false).build();
    private static final MarshallingInfo<Instant> LASTCHANGEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastChangedAt").isBinary(false).build();
    private static final MarshallingInfo<String> DISABLEDREASON_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("disabledReason").isBinary(false).build();
    private static final TransitionStateMarshaller INSTANCE = new TransitionStateMarshaller();

    private TransitionStateMarshaller() {
    }

    public static TransitionStateMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(TransitionState transitionState, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)transitionState, (String)"transitionState");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)transitionState.enabled(), ENABLED_BINDING);
            protocolMarshaller.marshall((Object)transitionState.lastChangedBy(), LASTCHANGEDBY_BINDING);
            protocolMarshaller.marshall((Object)transitionState.lastChangedAt(), LASTCHANGEDAT_BINDING);
            protocolMarshaller.marshall((Object)transitionState.disabledReason(), DISABLEDREASON_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

