/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.codepipeline.model.Artifact;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ArtifactMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").isBinary(false).build();
    private static final MarshallingInfo<String> REVISION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("revision").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> LOCATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("location").isBinary(false).build();
    private static final ArtifactMarshaller INSTANCE = new ArtifactMarshaller();

    private ArtifactMarshaller() {
    }

    public static ArtifactMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Artifact artifact, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)artifact, (String)"artifact");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)artifact.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)artifact.revision(), REVISION_BINDING);
            protocolMarshaller.marshall((Object)artifact.location(), LOCATION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

