/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.codepipeline.model.ArtifactLocation;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ArtifactLocationMarshaller {
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("type").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> S3LOCATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("s3Location").isBinary(false).build();
    private static final ArtifactLocationMarshaller INSTANCE = new ArtifactLocationMarshaller();

    private ArtifactLocationMarshaller() {
    }

    public static ArtifactLocationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ArtifactLocation artifactLocation, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)artifactLocation, (String)"artifactLocation");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)artifactLocation.typeString(), TYPE_BINDING);
            protocolMarshaller.marshall((Object)artifactLocation.s3Location(), S3LOCATION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

