/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.codepipeline.transform.PipelineMetadataMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PipelineMetadata
implements StructuredPojo,
ToCopyableBuilder<Builder, PipelineMetadata> {
    private final String pipelineArn;
    private final Instant created;
    private final Instant updated;

    private PipelineMetadata(BuilderImpl builder) {
        this.pipelineArn = builder.pipelineArn;
        this.created = builder.created;
        this.updated = builder.updated;
    }

    public String pipelineArn() {
        return this.pipelineArn;
    }

    public Instant created() {
        return this.created;
    }

    public Instant updated() {
        return this.updated;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.created());
        hashCode = 31 * hashCode + Objects.hashCode(this.updated());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PipelineMetadata)) {
            return false;
        }
        PipelineMetadata other = (PipelineMetadata)obj;
        return Objects.equals(this.pipelineArn(), other.pipelineArn()) && Objects.equals(this.created(), other.created()) && Objects.equals(this.updated(), other.updated());
    }

    public String toString() {
        return ToString.builder((String)"PipelineMetadata").add("PipelineArn", (Object)this.pipelineArn()).add("Created", (Object)this.created()).add("Updated", (Object)this.updated()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "pipelineArn": {
                return Optional.of(clazz.cast(this.pipelineArn()));
            }
            case "created": {
                return Optional.of(clazz.cast(this.created()));
            }
            case "updated": {
                return Optional.of(clazz.cast(this.updated()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PipelineMetadataMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String pipelineArn;
        private Instant created;
        private Instant updated;

        private BuilderImpl() {
        }

        private BuilderImpl(PipelineMetadata model) {
            this.pipelineArn(model.pipelineArn);
            this.created(model.created);
            this.updated(model.updated);
        }

        public final String getPipelineArn() {
            return this.pipelineArn;
        }

        @Override
        public final Builder pipelineArn(String pipelineArn) {
            this.pipelineArn = pipelineArn;
            return this;
        }

        public final void setPipelineArn(String pipelineArn) {
            this.pipelineArn = pipelineArn;
        }

        public final Instant getCreated() {
            return this.created;
        }

        @Override
        public final Builder created(Instant created) {
            this.created = created;
            return this;
        }

        public final void setCreated(Instant created) {
            this.created = created;
        }

        public final Instant getUpdated() {
            return this.updated;
        }

        @Override
        public final Builder updated(Instant updated) {
            this.updated = updated;
            return this;
        }

        public final void setUpdated(Instant updated) {
            this.updated = updated;
        }

        public PipelineMetadata build() {
            return new PipelineMetadata(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PipelineMetadata> {
        public Builder pipelineArn(String var1);

        public Builder created(Instant var1);

        public Builder updated(Instant var1);
    }
}

