/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.codepipeline.model.CodePipelineResponse;
import software.amazon.awssdk.services.codepipeline.model.ThirdPartyJob;
import software.amazon.awssdk.services.codepipeline.model.ThirdPartyJobListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PollForThirdPartyJobsResponse
extends CodePipelineResponse
implements ToCopyableBuilder<Builder, PollForThirdPartyJobsResponse> {
    private final List<ThirdPartyJob> jobs;

    private PollForThirdPartyJobsResponse(BuilderImpl builder) {
        super(builder);
        this.jobs = builder.jobs;
    }

    public List<ThirdPartyJob> jobs() {
        return this.jobs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.jobs());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PollForThirdPartyJobsResponse)) {
            return false;
        }
        PollForThirdPartyJobsResponse other = (PollForThirdPartyJobsResponse)((Object)obj);
        return Objects.equals(this.jobs(), other.jobs());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.jobs() != null) {
            sb.append("Jobs: ").append(this.jobs()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "jobs": {
                return Optional.of(clazz.cast(this.jobs()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CodePipelineResponse.BuilderImpl
    implements Builder {
        private List<ThirdPartyJob> jobs;

        private BuilderImpl() {
        }

        private BuilderImpl(PollForThirdPartyJobsResponse model) {
            this.jobs(model.jobs);
        }

        public final Collection<ThirdPartyJob.Builder> getJobs() {
            return this.jobs != null ? (Collection)this.jobs.stream().map(ThirdPartyJob::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder jobs(Collection<ThirdPartyJob> jobs) {
            this.jobs = ThirdPartyJobListCopier.copy(jobs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobs(ThirdPartyJob ... jobs) {
            this.jobs(Arrays.asList(jobs));
            return this;
        }

        public final void setJobs(Collection<ThirdPartyJob.BuilderImpl> jobs) {
            this.jobs = ThirdPartyJobListCopier.copyFromBuilder(jobs);
        }

        @Override
        public PollForThirdPartyJobsResponse build() {
            return new PollForThirdPartyJobsResponse(this);
        }
    }

    public static interface Builder
    extends CodePipelineResponse.Builder,
    CopyableBuilder<Builder, PollForThirdPartyJobsResponse> {
        public Builder jobs(Collection<ThirdPartyJob> var1);

        public Builder jobs(ThirdPartyJob ... var1);
    }
}

