/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.codepipeline.model.ActionOwner;
import software.amazon.awssdk.services.codepipeline.model.CodePipelineRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListActionTypesRequest
extends CodePipelineRequest
implements ToCopyableBuilder<Builder, ListActionTypesRequest> {
    private final String actionOwnerFilter;
    private final String nextToken;

    private ListActionTypesRequest(BuilderImpl builder) {
        super(builder);
        this.actionOwnerFilter = builder.actionOwnerFilter;
        this.nextToken = builder.nextToken;
    }

    public ActionOwner actionOwnerFilter() {
        return ActionOwner.fromValue(this.actionOwnerFilter);
    }

    public String actionOwnerFilterString() {
        return this.actionOwnerFilter;
    }

    public String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.actionOwnerFilterString());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListActionTypesRequest)) {
            return false;
        }
        ListActionTypesRequest other = (ListActionTypesRequest)((Object)obj);
        return Objects.equals(this.actionOwnerFilterString(), other.actionOwnerFilterString()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.actionOwnerFilterString() != null) {
            sb.append("ActionOwnerFilter: ").append(this.actionOwnerFilterString()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "actionOwnerFilter": {
                return Optional.of(clazz.cast(this.actionOwnerFilterString()));
            }
            case "nextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CodePipelineRequest.BuilderImpl
    implements Builder {
        private String actionOwnerFilter;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListActionTypesRequest model) {
            this.actionOwnerFilter(model.actionOwnerFilter);
            this.nextToken(model.nextToken);
        }

        public final String getActionOwnerFilter() {
            return this.actionOwnerFilter;
        }

        @Override
        public final Builder actionOwnerFilter(String actionOwnerFilter) {
            this.actionOwnerFilter = actionOwnerFilter;
            return this;
        }

        @Override
        public final Builder actionOwnerFilter(ActionOwner actionOwnerFilter) {
            this.actionOwnerFilter(actionOwnerFilter.toString());
            return this;
        }

        public final void setActionOwnerFilter(String actionOwnerFilter) {
            this.actionOwnerFilter = actionOwnerFilter;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public ListActionTypesRequest build() {
            return new ListActionTypesRequest(this);
        }
    }

    public static interface Builder
    extends CodePipelineRequest.Builder,
    CopyableBuilder<Builder, ListActionTypesRequest> {
        public Builder actionOwnerFilter(String var1);

        public Builder actionOwnerFilter(ActionOwner var1);

        public Builder nextToken(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

