/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.codepipeline.transform.ActionRevisionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ActionRevision
implements StructuredPojo,
ToCopyableBuilder<Builder, ActionRevision> {
    private final String revisionId;
    private final String revisionChangeId;
    private final Instant created;

    private ActionRevision(BuilderImpl builder) {
        this.revisionId = builder.revisionId;
        this.revisionChangeId = builder.revisionChangeId;
        this.created = builder.created;
    }

    public String revisionId() {
        return this.revisionId;
    }

    public String revisionChangeId() {
        return this.revisionChangeId;
    }

    public Instant created() {
        return this.created;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.revisionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.revisionChangeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.created());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActionRevision)) {
            return false;
        }
        ActionRevision other = (ActionRevision)obj;
        return Objects.equals(this.revisionId(), other.revisionId()) && Objects.equals(this.revisionChangeId(), other.revisionChangeId()) && Objects.equals(this.created(), other.created());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.revisionId() != null) {
            sb.append("RevisionId: ").append(this.revisionId()).append(",");
        }
        if (this.revisionChangeId() != null) {
            sb.append("RevisionChangeId: ").append(this.revisionChangeId()).append(",");
        }
        if (this.created() != null) {
            sb.append("Created: ").append(this.created()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "revisionId": {
                return Optional.of(clazz.cast(this.revisionId()));
            }
            case "revisionChangeId": {
                return Optional.of(clazz.cast(this.revisionChangeId()));
            }
            case "created": {
                return Optional.of(clazz.cast(this.created()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ActionRevisionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String revisionId;
        private String revisionChangeId;
        private Instant created;

        private BuilderImpl() {
        }

        private BuilderImpl(ActionRevision model) {
            this.revisionId(model.revisionId);
            this.revisionChangeId(model.revisionChangeId);
            this.created(model.created);
        }

        public final String getRevisionId() {
            return this.revisionId;
        }

        @Override
        public final Builder revisionId(String revisionId) {
            this.revisionId = revisionId;
            return this;
        }

        public final void setRevisionId(String revisionId) {
            this.revisionId = revisionId;
        }

        public final String getRevisionChangeId() {
            return this.revisionChangeId;
        }

        @Override
        public final Builder revisionChangeId(String revisionChangeId) {
            this.revisionChangeId = revisionChangeId;
            return this;
        }

        public final void setRevisionChangeId(String revisionChangeId) {
            this.revisionChangeId = revisionChangeId;
        }

        public final Instant getCreated() {
            return this.created;
        }

        @Override
        public final Builder created(Instant created) {
            this.created = created;
            return this;
        }

        public final void setCreated(Instant created) {
            this.created = created;
        }

        public ActionRevision build() {
            return new ActionRevision(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ActionRevision> {
        public Builder revisionId(String var1);

        public Builder revisionChangeId(String var1);

        public Builder created(Instant var1);
    }
}

