/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.codepipeline.model.Artifact;
import software.amazon.awssdk.services.codepipeline.transform.ArtifactLocationUnmarshaller;

public class ArtifactUnmarshaller
implements Unmarshaller<Artifact, JsonUnmarshallerContext> {
    private static final ArtifactUnmarshaller INSTANCE = new ArtifactUnmarshaller();

    public Artifact unmarshall(JsonUnmarshallerContext context) throws Exception {
        Artifact.Builder artifactBuilder = Artifact.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("name", targetDepth)) {
                    context.nextToken();
                    artifactBuilder.name((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("revision", targetDepth)) {
                    context.nextToken();
                    artifactBuilder.revision((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("location", targetDepth)) {
                    context.nextToken();
                    artifactBuilder.location(ArtifactLocationUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (Artifact)artifactBuilder.build();
    }

    public static ArtifactUnmarshaller getInstance() {
        return INSTANCE;
    }
}

