/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.codepipeline.model.ActionContext;
import software.amazon.awssdk.services.codepipeline.model.StageContext;
import software.amazon.awssdk.services.codepipeline.transform.PipelineContextMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PipelineContext
implements StructuredPojo,
ToCopyableBuilder<Builder, PipelineContext> {
    private final String pipelineName;
    private final StageContext stage;
    private final ActionContext action;

    private PipelineContext(BuilderImpl builder) {
        this.pipelineName = builder.pipelineName;
        this.stage = builder.stage;
        this.action = builder.action;
    }

    public String pipelineName() {
        return this.pipelineName;
    }

    public StageContext stage() {
        return this.stage;
    }

    public ActionContext action() {
        return this.action;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineName());
        hashCode = 31 * hashCode + Objects.hashCode(this.stage());
        hashCode = 31 * hashCode + Objects.hashCode(this.action());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PipelineContext)) {
            return false;
        }
        PipelineContext other = (PipelineContext)obj;
        return Objects.equals(this.pipelineName(), other.pipelineName()) && Objects.equals(this.stage(), other.stage()) && Objects.equals(this.action(), other.action());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.pipelineName() != null) {
            sb.append("PipelineName: ").append(this.pipelineName()).append(",");
        }
        if (this.stage() != null) {
            sb.append("Stage: ").append(this.stage()).append(",");
        }
        if (this.action() != null) {
            sb.append("Action: ").append(this.action()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "pipelineName": {
                return Optional.of(clazz.cast(this.pipelineName()));
            }
            case "stage": {
                return Optional.of(clazz.cast(this.stage()));
            }
            case "action": {
                return Optional.of(clazz.cast(this.action()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PipelineContextMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String pipelineName;
        private StageContext stage;
        private ActionContext action;

        private BuilderImpl() {
        }

        private BuilderImpl(PipelineContext model) {
            this.pipelineName(model.pipelineName);
            this.stage(model.stage);
            this.action(model.action);
        }

        public final String getPipelineName() {
            return this.pipelineName;
        }

        @Override
        public final Builder pipelineName(String pipelineName) {
            this.pipelineName = pipelineName;
            return this;
        }

        public final void setPipelineName(String pipelineName) {
            this.pipelineName = pipelineName;
        }

        public final StageContext.Builder getStage() {
            return this.stage != null ? this.stage.toBuilder() : null;
        }

        @Override
        public final Builder stage(StageContext stage) {
            this.stage = stage;
            return this;
        }

        public final void setStage(StageContext.BuilderImpl stage) {
            this.stage = stage != null ? stage.build() : null;
        }

        public final ActionContext.Builder getAction() {
            return this.action != null ? this.action.toBuilder() : null;
        }

        @Override
        public final Builder action(ActionContext action) {
            this.action = action;
            return this;
        }

        public final void setAction(ActionContext.BuilderImpl action) {
            this.action = action != null ? action.build() : null;
        }

        public PipelineContext build() {
            return new PipelineContext(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PipelineContext> {
        public Builder pipelineName(String var1);

        public Builder stage(StageContext var1);

        default public Builder stage(Consumer<StageContext.Builder> stage) {
            return this.stage((StageContext)((StageContext.Builder)StageContext.builder().apply(stage)).build());
        }

        public Builder action(ActionContext var1);

        default public Builder action(Consumer<ActionContext.Builder> action) {
            return this.action((ActionContext)((ActionContext.Builder)ActionContext.builder().apply(action)).build());
        }
    }
}

