/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.codepipeline.model.StageTransitionType;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DisableStageTransitionRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DisableStageTransitionRequest> {
    private final String pipelineName;
    private final String stageName;
    private final String transitionType;
    private final String reason;

    private DisableStageTransitionRequest(BuilderImpl builder) {
        this.pipelineName = builder.pipelineName;
        this.stageName = builder.stageName;
        this.transitionType = builder.transitionType;
        this.reason = builder.reason;
    }

    public String pipelineName() {
        return this.pipelineName;
    }

    public String stageName() {
        return this.stageName;
    }

    public StageTransitionType transitionType() {
        return StageTransitionType.fromValue(this.transitionType);
    }

    public String transitionTypeString() {
        return this.transitionType;
    }

    public String reason() {
        return this.reason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineName());
        hashCode = 31 * hashCode + Objects.hashCode(this.stageName());
        hashCode = 31 * hashCode + Objects.hashCode(this.transitionTypeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.reason());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisableStageTransitionRequest)) {
            return false;
        }
        DisableStageTransitionRequest other = (DisableStageTransitionRequest)((Object)obj);
        return Objects.equals(this.pipelineName(), other.pipelineName()) && Objects.equals(this.stageName(), other.stageName()) && Objects.equals(this.transitionTypeString(), other.transitionTypeString()) && Objects.equals(this.reason(), other.reason());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.pipelineName() != null) {
            sb.append("PipelineName: ").append(this.pipelineName()).append(",");
        }
        if (this.stageName() != null) {
            sb.append("StageName: ").append(this.stageName()).append(",");
        }
        if (this.transitionTypeString() != null) {
            sb.append("TransitionType: ").append(this.transitionTypeString()).append(",");
        }
        if (this.reason() != null) {
            sb.append("Reason: ").append(this.reason()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "pipelineName": {
                return Optional.of(clazz.cast(this.pipelineName()));
            }
            case "stageName": {
                return Optional.of(clazz.cast(this.stageName()));
            }
            case "transitionType": {
                return Optional.of(clazz.cast(this.transitionTypeString()));
            }
            case "reason": {
                return Optional.of(clazz.cast(this.reason()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String pipelineName;
        private String stageName;
        private String transitionType;
        private String reason;

        private BuilderImpl() {
        }

        private BuilderImpl(DisableStageTransitionRequest model) {
            this.pipelineName(model.pipelineName);
            this.stageName(model.stageName);
            this.transitionType(model.transitionType);
            this.reason(model.reason);
        }

        public final String getPipelineName() {
            return this.pipelineName;
        }

        @Override
        public final Builder pipelineName(String pipelineName) {
            this.pipelineName = pipelineName;
            return this;
        }

        public final void setPipelineName(String pipelineName) {
            this.pipelineName = pipelineName;
        }

        public final String getStageName() {
            return this.stageName;
        }

        @Override
        public final Builder stageName(String stageName) {
            this.stageName = stageName;
            return this;
        }

        public final void setStageName(String stageName) {
            this.stageName = stageName;
        }

        public final String getTransitionType() {
            return this.transitionType;
        }

        @Override
        public final Builder transitionType(String transitionType) {
            this.transitionType = transitionType;
            return this;
        }

        @Override
        public final Builder transitionType(StageTransitionType transitionType) {
            this.transitionType(transitionType.toString());
            return this;
        }

        public final void setTransitionType(String transitionType) {
            this.transitionType = transitionType;
        }

        public final String getReason() {
            return this.reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        public DisableStageTransitionRequest build() {
            return new DisableStageTransitionRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DisableStageTransitionRequest> {
        public Builder pipelineName(String var1);

        public Builder stageName(String var1);

        public Builder transitionType(String var1);

        public Builder transitionType(StageTransitionType var1);

        public Builder reason(String var1);
    }
}

