/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.codepipeline.model.ActionConfigurationProperty;
import software.amazon.awssdk.services.codepipeline.model.ActionConfigurationPropertyListCopier;
import software.amazon.awssdk.services.codepipeline.model.ActionTypeId;
import software.amazon.awssdk.services.codepipeline.model.ActionTypeSettings;
import software.amazon.awssdk.services.codepipeline.model.ArtifactDetails;
import software.amazon.awssdk.services.codepipeline.transform.ActionTypeMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ActionType
implements StructuredPojo,
ToCopyableBuilder<Builder, ActionType> {
    private final ActionTypeId id;
    private final ActionTypeSettings settings;
    private final List<ActionConfigurationProperty> actionConfigurationProperties;
    private final ArtifactDetails inputArtifactDetails;
    private final ArtifactDetails outputArtifactDetails;

    private ActionType(BuilderImpl builder) {
        this.id = builder.id;
        this.settings = builder.settings;
        this.actionConfigurationProperties = builder.actionConfigurationProperties;
        this.inputArtifactDetails = builder.inputArtifactDetails;
        this.outputArtifactDetails = builder.outputArtifactDetails;
    }

    public ActionTypeId id() {
        return this.id;
    }

    public ActionTypeSettings settings() {
        return this.settings;
    }

    public List<ActionConfigurationProperty> actionConfigurationProperties() {
        return this.actionConfigurationProperties;
    }

    public ArtifactDetails inputArtifactDetails() {
        return this.inputArtifactDetails;
    }

    public ArtifactDetails outputArtifactDetails() {
        return this.outputArtifactDetails;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.id() == null ? 0 : this.id().hashCode());
        hashCode = 31 * hashCode + (this.settings() == null ? 0 : this.settings().hashCode());
        hashCode = 31 * hashCode + (this.actionConfigurationProperties() == null ? 0 : this.actionConfigurationProperties().hashCode());
        hashCode = 31 * hashCode + (this.inputArtifactDetails() == null ? 0 : this.inputArtifactDetails().hashCode());
        hashCode = 31 * hashCode + (this.outputArtifactDetails() == null ? 0 : this.outputArtifactDetails().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActionType)) {
            return false;
        }
        ActionType other = (ActionType)obj;
        if (other.id() == null ^ this.id() == null) {
            return false;
        }
        if (other.id() != null && !other.id().equals(this.id())) {
            return false;
        }
        if (other.settings() == null ^ this.settings() == null) {
            return false;
        }
        if (other.settings() != null && !other.settings().equals(this.settings())) {
            return false;
        }
        if (other.actionConfigurationProperties() == null ^ this.actionConfigurationProperties() == null) {
            return false;
        }
        if (other.actionConfigurationProperties() != null && !other.actionConfigurationProperties().equals(this.actionConfigurationProperties())) {
            return false;
        }
        if (other.inputArtifactDetails() == null ^ this.inputArtifactDetails() == null) {
            return false;
        }
        if (other.inputArtifactDetails() != null && !other.inputArtifactDetails().equals(this.inputArtifactDetails())) {
            return false;
        }
        if (other.outputArtifactDetails() == null ^ this.outputArtifactDetails() == null) {
            return false;
        }
        return other.outputArtifactDetails() == null || other.outputArtifactDetails().equals(this.outputArtifactDetails());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.id() != null) {
            sb.append("Id: ").append(this.id()).append(",");
        }
        if (this.settings() != null) {
            sb.append("Settings: ").append(this.settings()).append(",");
        }
        if (this.actionConfigurationProperties() != null) {
            sb.append("ActionConfigurationProperties: ").append(this.actionConfigurationProperties()).append(",");
        }
        if (this.inputArtifactDetails() != null) {
            sb.append("InputArtifactDetails: ").append(this.inputArtifactDetails()).append(",");
        }
        if (this.outputArtifactDetails() != null) {
            sb.append("OutputArtifactDetails: ").append(this.outputArtifactDetails()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.of(clazz.cast(this.id()));
            }
            case "settings": {
                return Optional.of(clazz.cast(this.settings()));
            }
            case "actionConfigurationProperties": {
                return Optional.of(clazz.cast(this.actionConfigurationProperties()));
            }
            case "inputArtifactDetails": {
                return Optional.of(clazz.cast(this.inputArtifactDetails()));
            }
            case "outputArtifactDetails": {
                return Optional.of(clazz.cast(this.outputArtifactDetails()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ActionTypeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private ActionTypeId id;
        private ActionTypeSettings settings;
        private List<ActionConfigurationProperty> actionConfigurationProperties;
        private ArtifactDetails inputArtifactDetails;
        private ArtifactDetails outputArtifactDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(ActionType model) {
            this.id(model.id);
            this.settings(model.settings);
            this.actionConfigurationProperties(model.actionConfigurationProperties);
            this.inputArtifactDetails(model.inputArtifactDetails);
            this.outputArtifactDetails(model.outputArtifactDetails);
        }

        public final ActionTypeId.Builder getId() {
            return this.id != null ? this.id.toBuilder() : null;
        }

        @Override
        public final Builder id(ActionTypeId id) {
            this.id = id;
            return this;
        }

        public final void setId(ActionTypeId.BuilderImpl id) {
            this.id = id != null ? id.build() : null;
        }

        public final ActionTypeSettings.Builder getSettings() {
            return this.settings != null ? this.settings.toBuilder() : null;
        }

        @Override
        public final Builder settings(ActionTypeSettings settings) {
            this.settings = settings;
            return this;
        }

        public final void setSettings(ActionTypeSettings.BuilderImpl settings) {
            this.settings = settings != null ? settings.build() : null;
        }

        public final Collection<ActionConfigurationProperty.Builder> getActionConfigurationProperties() {
            return this.actionConfigurationProperties != null ? (Collection)this.actionConfigurationProperties.stream().map(ActionConfigurationProperty::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder actionConfigurationProperties(Collection<ActionConfigurationProperty> actionConfigurationProperties) {
            this.actionConfigurationProperties = ActionConfigurationPropertyListCopier.copy(actionConfigurationProperties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionConfigurationProperties(ActionConfigurationProperty ... actionConfigurationProperties) {
            this.actionConfigurationProperties(Arrays.asList(actionConfigurationProperties));
            return this;
        }

        public final void setActionConfigurationProperties(Collection<ActionConfigurationProperty.BuilderImpl> actionConfigurationProperties) {
            this.actionConfigurationProperties = ActionConfigurationPropertyListCopier.copyFromBuilder(actionConfigurationProperties);
        }

        public final ArtifactDetails.Builder getInputArtifactDetails() {
            return this.inputArtifactDetails != null ? this.inputArtifactDetails.toBuilder() : null;
        }

        @Override
        public final Builder inputArtifactDetails(ArtifactDetails inputArtifactDetails) {
            this.inputArtifactDetails = inputArtifactDetails;
            return this;
        }

        public final void setInputArtifactDetails(ArtifactDetails.BuilderImpl inputArtifactDetails) {
            this.inputArtifactDetails = inputArtifactDetails != null ? inputArtifactDetails.build() : null;
        }

        public final ArtifactDetails.Builder getOutputArtifactDetails() {
            return this.outputArtifactDetails != null ? this.outputArtifactDetails.toBuilder() : null;
        }

        @Override
        public final Builder outputArtifactDetails(ArtifactDetails outputArtifactDetails) {
            this.outputArtifactDetails = outputArtifactDetails;
            return this;
        }

        public final void setOutputArtifactDetails(ArtifactDetails.BuilderImpl outputArtifactDetails) {
            this.outputArtifactDetails = outputArtifactDetails != null ? outputArtifactDetails.build() : null;
        }

        public ActionType build() {
            return new ActionType(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ActionType> {
        public Builder id(ActionTypeId var1);

        public Builder settings(ActionTypeSettings var1);

        public Builder actionConfigurationProperties(Collection<ActionConfigurationProperty> var1);

        public Builder actionConfigurationProperties(ActionConfigurationProperty ... var1);

        public Builder inputArtifactDetails(ArtifactDetails var1);

        public Builder outputArtifactDetails(ArtifactDetails var1);
    }
}

