/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.codepipeline.model.ActionExecution;
import software.amazon.awssdk.services.codepipeline.model.ActionRevision;
import software.amazon.awssdk.services.codepipeline.transform.ActionStateMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ActionState
implements StructuredPojo,
ToCopyableBuilder<Builder, ActionState> {
    private final String actionName;
    private final ActionRevision currentRevision;
    private final ActionExecution latestExecution;
    private final String entityUrl;
    private final String revisionUrl;

    private ActionState(BuilderImpl builder) {
        this.actionName = builder.actionName;
        this.currentRevision = builder.currentRevision;
        this.latestExecution = builder.latestExecution;
        this.entityUrl = builder.entityUrl;
        this.revisionUrl = builder.revisionUrl;
    }

    public String actionName() {
        return this.actionName;
    }

    public ActionRevision currentRevision() {
        return this.currentRevision;
    }

    public ActionExecution latestExecution() {
        return this.latestExecution;
    }

    public String entityUrl() {
        return this.entityUrl;
    }

    public String revisionUrl() {
        return this.revisionUrl;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.actionName() == null ? 0 : this.actionName().hashCode());
        hashCode = 31 * hashCode + (this.currentRevision() == null ? 0 : this.currentRevision().hashCode());
        hashCode = 31 * hashCode + (this.latestExecution() == null ? 0 : this.latestExecution().hashCode());
        hashCode = 31 * hashCode + (this.entityUrl() == null ? 0 : this.entityUrl().hashCode());
        hashCode = 31 * hashCode + (this.revisionUrl() == null ? 0 : this.revisionUrl().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActionState)) {
            return false;
        }
        ActionState other = (ActionState)obj;
        if (other.actionName() == null ^ this.actionName() == null) {
            return false;
        }
        if (other.actionName() != null && !other.actionName().equals(this.actionName())) {
            return false;
        }
        if (other.currentRevision() == null ^ this.currentRevision() == null) {
            return false;
        }
        if (other.currentRevision() != null && !other.currentRevision().equals(this.currentRevision())) {
            return false;
        }
        if (other.latestExecution() == null ^ this.latestExecution() == null) {
            return false;
        }
        if (other.latestExecution() != null && !other.latestExecution().equals(this.latestExecution())) {
            return false;
        }
        if (other.entityUrl() == null ^ this.entityUrl() == null) {
            return false;
        }
        if (other.entityUrl() != null && !other.entityUrl().equals(this.entityUrl())) {
            return false;
        }
        if (other.revisionUrl() == null ^ this.revisionUrl() == null) {
            return false;
        }
        return other.revisionUrl() == null || other.revisionUrl().equals(this.revisionUrl());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.actionName() != null) {
            sb.append("ActionName: ").append(this.actionName()).append(",");
        }
        if (this.currentRevision() != null) {
            sb.append("CurrentRevision: ").append(this.currentRevision()).append(",");
        }
        if (this.latestExecution() != null) {
            sb.append("LatestExecution: ").append(this.latestExecution()).append(",");
        }
        if (this.entityUrl() != null) {
            sb.append("EntityUrl: ").append(this.entityUrl()).append(",");
        }
        if (this.revisionUrl() != null) {
            sb.append("RevisionUrl: ").append(this.revisionUrl()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "actionName": {
                return Optional.of(clazz.cast(this.actionName()));
            }
            case "currentRevision": {
                return Optional.of(clazz.cast(this.currentRevision()));
            }
            case "latestExecution": {
                return Optional.of(clazz.cast(this.latestExecution()));
            }
            case "entityUrl": {
                return Optional.of(clazz.cast(this.entityUrl()));
            }
            case "revisionUrl": {
                return Optional.of(clazz.cast(this.revisionUrl()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ActionStateMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String actionName;
        private ActionRevision currentRevision;
        private ActionExecution latestExecution;
        private String entityUrl;
        private String revisionUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(ActionState model) {
            this.actionName(model.actionName);
            this.currentRevision(model.currentRevision);
            this.latestExecution(model.latestExecution);
            this.entityUrl(model.entityUrl);
            this.revisionUrl(model.revisionUrl);
        }

        public final String getActionName() {
            return this.actionName;
        }

        @Override
        public final Builder actionName(String actionName) {
            this.actionName = actionName;
            return this;
        }

        public final void setActionName(String actionName) {
            this.actionName = actionName;
        }

        public final ActionRevision.Builder getCurrentRevision() {
            return this.currentRevision != null ? this.currentRevision.toBuilder() : null;
        }

        @Override
        public final Builder currentRevision(ActionRevision currentRevision) {
            this.currentRevision = currentRevision;
            return this;
        }

        public final void setCurrentRevision(ActionRevision.BuilderImpl currentRevision) {
            this.currentRevision = currentRevision != null ? currentRevision.build() : null;
        }

        public final ActionExecution.Builder getLatestExecution() {
            return this.latestExecution != null ? this.latestExecution.toBuilder() : null;
        }

        @Override
        public final Builder latestExecution(ActionExecution latestExecution) {
            this.latestExecution = latestExecution;
            return this;
        }

        public final void setLatestExecution(ActionExecution.BuilderImpl latestExecution) {
            this.latestExecution = latestExecution != null ? latestExecution.build() : null;
        }

        public final String getEntityUrl() {
            return this.entityUrl;
        }

        @Override
        public final Builder entityUrl(String entityUrl) {
            this.entityUrl = entityUrl;
            return this;
        }

        public final void setEntityUrl(String entityUrl) {
            this.entityUrl = entityUrl;
        }

        public final String getRevisionUrl() {
            return this.revisionUrl;
        }

        @Override
        public final Builder revisionUrl(String revisionUrl) {
            this.revisionUrl = revisionUrl;
            return this;
        }

        public final void setRevisionUrl(String revisionUrl) {
            this.revisionUrl = revisionUrl;
        }

        public ActionState build() {
            return new ActionState(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ActionState> {
        public Builder actionName(String var1);

        public Builder currentRevision(ActionRevision var1);

        public Builder latestExecution(ActionExecution var1);

        public Builder entityUrl(String var1);

        public Builder revisionUrl(String var1);
    }
}

