/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.codepipeline.model.JobData;
import software.amazon.awssdk.services.codepipeline.transform.AWSSessionCredentialsUnmarshaller;
import software.amazon.awssdk.services.codepipeline.transform.ActionConfigurationUnmarshaller;
import software.amazon.awssdk.services.codepipeline.transform.ActionTypeIdUnmarshaller;
import software.amazon.awssdk.services.codepipeline.transform.ArtifactUnmarshaller;
import software.amazon.awssdk.services.codepipeline.transform.EncryptionKeyUnmarshaller;
import software.amazon.awssdk.services.codepipeline.transform.PipelineContextUnmarshaller;

public class JobDataUnmarshaller
implements Unmarshaller<JobData, JsonUnmarshallerContext> {
    private static final JobDataUnmarshaller INSTANCE = new JobDataUnmarshaller();

    public JobData unmarshall(JsonUnmarshallerContext context) throws Exception {
        JobData.Builder jobDataBuilder = JobData.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("actionTypeId", targetDepth)) {
                    context.nextToken();
                    jobDataBuilder.actionTypeId(ActionTypeIdUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("actionConfiguration", targetDepth)) {
                    context.nextToken();
                    jobDataBuilder.actionConfiguration(ActionConfigurationUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("pipelineContext", targetDepth)) {
                    context.nextToken();
                    jobDataBuilder.pipelineContext(PipelineContextUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("inputArtifacts", targetDepth)) {
                    context.nextToken();
                    jobDataBuilder.inputArtifacts(new ListUnmarshaller((Unmarshaller)ArtifactUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("outputArtifacts", targetDepth)) {
                    context.nextToken();
                    jobDataBuilder.outputArtifacts(new ListUnmarshaller((Unmarshaller)ArtifactUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("artifactCredentials", targetDepth)) {
                    context.nextToken();
                    jobDataBuilder.artifactCredentials(AWSSessionCredentialsUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("continuationToken", targetDepth)) {
                    context.nextToken();
                    jobDataBuilder.continuationToken((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("encryptionKey", targetDepth)) {
                    context.nextToken();
                    jobDataBuilder.encryptionKey(EncryptionKeyUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (JobData)jobDataBuilder.build();
    }

    public static JobDataUnmarshaller getInstance() {
        return INSTANCE;
    }
}

