/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.time.Instant;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.codepipeline.transform.TransitionStateMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class TransitionState
implements StructuredPojo,
ToCopyableBuilder<Builder, TransitionState> {
    private final Boolean enabled;
    private final String lastChangedBy;
    private final Instant lastChangedAt;
    private final String disabledReason;

    private TransitionState(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.lastChangedBy = builder.lastChangedBy;
        this.lastChangedAt = builder.lastChangedAt;
        this.disabledReason = builder.disabledReason;
    }

    public Boolean enabled() {
        return this.enabled;
    }

    public String lastChangedBy() {
        return this.lastChangedBy;
    }

    public Instant lastChangedAt() {
        return this.lastChangedAt;
    }

    public String disabledReason() {
        return this.disabledReason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.enabled() == null ? 0 : this.enabled().hashCode());
        hashCode = 31 * hashCode + (this.lastChangedBy() == null ? 0 : this.lastChangedBy().hashCode());
        hashCode = 31 * hashCode + (this.lastChangedAt() == null ? 0 : this.lastChangedAt().hashCode());
        hashCode = 31 * hashCode + (this.disabledReason() == null ? 0 : this.disabledReason().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransitionState)) {
            return false;
        }
        TransitionState other = (TransitionState)obj;
        if (other.enabled() == null ^ this.enabled() == null) {
            return false;
        }
        if (other.enabled() != null && !other.enabled().equals(this.enabled())) {
            return false;
        }
        if (other.lastChangedBy() == null ^ this.lastChangedBy() == null) {
            return false;
        }
        if (other.lastChangedBy() != null && !other.lastChangedBy().equals(this.lastChangedBy())) {
            return false;
        }
        if (other.lastChangedAt() == null ^ this.lastChangedAt() == null) {
            return false;
        }
        if (other.lastChangedAt() != null && !other.lastChangedAt().equals(this.lastChangedAt())) {
            return false;
        }
        if (other.disabledReason() == null ^ this.disabledReason() == null) {
            return false;
        }
        return other.disabledReason() == null || other.disabledReason().equals(this.disabledReason());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.enabled() != null) {
            sb.append("Enabled: ").append(this.enabled()).append(",");
        }
        if (this.lastChangedBy() != null) {
            sb.append("LastChangedBy: ").append(this.lastChangedBy()).append(",");
        }
        if (this.lastChangedAt() != null) {
            sb.append("LastChangedAt: ").append(this.lastChangedAt()).append(",");
        }
        if (this.disabledReason() != null) {
            sb.append("DisabledReason: ").append(this.disabledReason()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TransitionStateMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private Boolean enabled;
        private String lastChangedBy;
        private Instant lastChangedAt;
        private String disabledReason;

        private BuilderImpl() {
        }

        private BuilderImpl(TransitionState model) {
            this.setEnabled(model.enabled);
            this.setLastChangedBy(model.lastChangedBy);
            this.setLastChangedAt(model.lastChangedAt);
            this.setDisabledReason(model.disabledReason);
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public final String getLastChangedBy() {
            return this.lastChangedBy;
        }

        @Override
        public final Builder lastChangedBy(String lastChangedBy) {
            this.lastChangedBy = lastChangedBy;
            return this;
        }

        public final void setLastChangedBy(String lastChangedBy) {
            this.lastChangedBy = lastChangedBy;
        }

        public final Instant getLastChangedAt() {
            return this.lastChangedAt;
        }

        @Override
        public final Builder lastChangedAt(Instant lastChangedAt) {
            this.lastChangedAt = lastChangedAt;
            return this;
        }

        public final void setLastChangedAt(Instant lastChangedAt) {
            this.lastChangedAt = lastChangedAt;
        }

        public final String getDisabledReason() {
            return this.disabledReason;
        }

        @Override
        public final Builder disabledReason(String disabledReason) {
            this.disabledReason = disabledReason;
            return this;
        }

        public final void setDisabledReason(String disabledReason) {
            this.disabledReason = disabledReason;
        }

        public TransitionState build() {
            return new TransitionState(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, TransitionState> {
        public Builder enabled(Boolean var1);

        public Builder lastChangedBy(String var1);

        public Builder lastChangedAt(Instant var1);

        public Builder disabledReason(String var1);
    }
}

