/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.codepipeline.transform.S3ArtifactLocationMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class S3ArtifactLocation
implements StructuredPojo,
ToCopyableBuilder<Builder, S3ArtifactLocation> {
    private final String bucketName;
    private final String objectKey;

    private S3ArtifactLocation(BuilderImpl builder) {
        this.bucketName = builder.bucketName;
        this.objectKey = builder.objectKey;
    }

    public String bucketName() {
        return this.bucketName;
    }

    public String objectKey() {
        return this.objectKey;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.bucketName() == null ? 0 : this.bucketName().hashCode());
        hashCode = 31 * hashCode + (this.objectKey() == null ? 0 : this.objectKey().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3ArtifactLocation)) {
            return false;
        }
        S3ArtifactLocation other = (S3ArtifactLocation)obj;
        if (other.bucketName() == null ^ this.bucketName() == null) {
            return false;
        }
        if (other.bucketName() != null && !other.bucketName().equals(this.bucketName())) {
            return false;
        }
        if (other.objectKey() == null ^ this.objectKey() == null) {
            return false;
        }
        return other.objectKey() == null || other.objectKey().equals(this.objectKey());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.bucketName() != null) {
            sb.append("BucketName: ").append(this.bucketName()).append(",");
        }
        if (this.objectKey() != null) {
            sb.append("ObjectKey: ").append(this.objectKey()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        S3ArtifactLocationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String bucketName;
        private String objectKey;

        private BuilderImpl() {
        }

        private BuilderImpl(S3ArtifactLocation model) {
            this.setBucketName(model.bucketName);
            this.setObjectKey(model.objectKey);
        }

        public final String getBucketName() {
            return this.bucketName;
        }

        @Override
        public final Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public final void setBucketName(String bucketName) {
            this.bucketName = bucketName;
        }

        public final String getObjectKey() {
            return this.objectKey;
        }

        @Override
        public final Builder objectKey(String objectKey) {
            this.objectKey = objectKey;
            return this;
        }

        public final void setObjectKey(String objectKey) {
            this.objectKey = objectKey;
        }

        public S3ArtifactLocation build() {
            return new S3ArtifactLocation(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, S3ArtifactLocation> {
        public Builder bucketName(String var1);

        public Builder objectKey(String var1);
    }
}

