/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.codepipeline.model.ApprovalStatus;
import software.amazon.awssdk.services.codepipeline.transform.ApprovalResultMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ApprovalResult
implements StructuredPojo,
ToCopyableBuilder<Builder, ApprovalResult> {
    private final String summary;
    private final String status;

    private ApprovalResult(BuilderImpl builder) {
        this.summary = builder.summary;
        this.status = builder.status;
    }

    public String summary() {
        return this.summary;
    }

    public ApprovalStatus status() {
        return ApprovalStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.summary());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApprovalResult)) {
            return false;
        }
        ApprovalResult other = (ApprovalResult)obj;
        return Objects.equals(this.summary(), other.summary()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public String toString() {
        return ToString.builder((String)"ApprovalResult").add("Summary", (Object)this.summary()).add("Status", (Object)this.statusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "summary": {
                return Optional.ofNullable(clazz.cast(this.summary()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ApprovalResultMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String summary;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(ApprovalResult model) {
            this.summary(model.summary);
            this.status(model.status);
        }

        public final String getSummary() {
            return this.summary;
        }

        @Override
        public final Builder summary(String summary) {
            this.summary = summary;
            return this;
        }

        public final void setSummary(String summary) {
            this.summary = summary;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ApprovalStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public ApprovalResult build() {
            return new ApprovalResult(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ApprovalResult> {
        public Builder summary(String var1);

        public Builder status(String var1);

        public Builder status(ApprovalStatus var1);
    }
}

