/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.codepipeline.model.CodePipelineRequest;
import software.amazon.awssdk.services.codepipeline.model.StageRetryMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RetryStageExecutionRequest
extends CodePipelineRequest
implements ToCopyableBuilder<Builder, RetryStageExecutionRequest> {
    private final String pipelineName;
    private final String stageName;
    private final String pipelineExecutionId;
    private final String retryMode;

    private RetryStageExecutionRequest(BuilderImpl builder) {
        super(builder);
        this.pipelineName = builder.pipelineName;
        this.stageName = builder.stageName;
        this.pipelineExecutionId = builder.pipelineExecutionId;
        this.retryMode = builder.retryMode;
    }

    public String pipelineName() {
        return this.pipelineName;
    }

    public String stageName() {
        return this.stageName;
    }

    public String pipelineExecutionId() {
        return this.pipelineExecutionId;
    }

    public StageRetryMode retryMode() {
        return StageRetryMode.fromValue(this.retryMode);
    }

    public String retryModeAsString() {
        return this.retryMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineName());
        hashCode = 31 * hashCode + Objects.hashCode(this.stageName());
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineExecutionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.retryModeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RetryStageExecutionRequest)) {
            return false;
        }
        RetryStageExecutionRequest other = (RetryStageExecutionRequest)((Object)obj);
        return Objects.equals(this.pipelineName(), other.pipelineName()) && Objects.equals(this.stageName(), other.stageName()) && Objects.equals(this.pipelineExecutionId(), other.pipelineExecutionId()) && Objects.equals(this.retryModeAsString(), other.retryModeAsString());
    }

    public String toString() {
        return ToString.builder((String)"RetryStageExecutionRequest").add("PipelineName", (Object)this.pipelineName()).add("StageName", (Object)this.stageName()).add("PipelineExecutionId", (Object)this.pipelineExecutionId()).add("RetryMode", (Object)this.retryModeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "pipelineName": {
                return Optional.ofNullable(clazz.cast(this.pipelineName()));
            }
            case "stageName": {
                return Optional.ofNullable(clazz.cast(this.stageName()));
            }
            case "pipelineExecutionId": {
                return Optional.ofNullable(clazz.cast(this.pipelineExecutionId()));
            }
            case "retryMode": {
                return Optional.ofNullable(clazz.cast(this.retryModeAsString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CodePipelineRequest.BuilderImpl
    implements Builder {
        private String pipelineName;
        private String stageName;
        private String pipelineExecutionId;
        private String retryMode;

        private BuilderImpl() {
        }

        private BuilderImpl(RetryStageExecutionRequest model) {
            super(model);
            this.pipelineName(model.pipelineName);
            this.stageName(model.stageName);
            this.pipelineExecutionId(model.pipelineExecutionId);
            this.retryMode(model.retryMode);
        }

        public final String getPipelineName() {
            return this.pipelineName;
        }

        @Override
        public final Builder pipelineName(String pipelineName) {
            this.pipelineName = pipelineName;
            return this;
        }

        public final void setPipelineName(String pipelineName) {
            this.pipelineName = pipelineName;
        }

        public final String getStageName() {
            return this.stageName;
        }

        @Override
        public final Builder stageName(String stageName) {
            this.stageName = stageName;
            return this;
        }

        public final void setStageName(String stageName) {
            this.stageName = stageName;
        }

        public final String getPipelineExecutionId() {
            return this.pipelineExecutionId;
        }

        @Override
        public final Builder pipelineExecutionId(String pipelineExecutionId) {
            this.pipelineExecutionId = pipelineExecutionId;
            return this;
        }

        public final void setPipelineExecutionId(String pipelineExecutionId) {
            this.pipelineExecutionId = pipelineExecutionId;
        }

        public final String getRetryMode() {
            return this.retryMode;
        }

        @Override
        public final Builder retryMode(String retryMode) {
            this.retryMode = retryMode;
            return this;
        }

        @Override
        public final Builder retryMode(StageRetryMode retryMode) {
            this.retryMode(retryMode.toString());
            return this;
        }

        public final void setRetryMode(String retryMode) {
            this.retryMode = retryMode;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RetryStageExecutionRequest build() {
            return new RetryStageExecutionRequest(this);
        }
    }

    public static interface Builder
    extends CodePipelineRequest.Builder,
    CopyableBuilder<Builder, RetryStageExecutionRequest> {
        public Builder pipelineName(String var1);

        public Builder stageName(String var1);

        public Builder pipelineExecutionId(String var1);

        public Builder retryMode(String var1);

        public Builder retryMode(StageRetryMode var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

