/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.codepipeline.model.PipelineExecutionSummary;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class PipelineExecutionSummaryMarshaller {
    private static final MarshallingInfo<String> PIPELINEEXECUTIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("pipelineExecutionId").isBinary(false).build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("status").isBinary(false).build();
    private static final MarshallingInfo<Instant> STARTTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("startTime").isBinary(false).build();
    private static final MarshallingInfo<Instant> LASTUPDATETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastUpdateTime").isBinary(false).build();
    private static final PipelineExecutionSummaryMarshaller INSTANCE = new PipelineExecutionSummaryMarshaller();

    private PipelineExecutionSummaryMarshaller() {
    }

    public static PipelineExecutionSummaryMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(PipelineExecutionSummary pipelineExecutionSummary, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)pipelineExecutionSummary, (String)"pipelineExecutionSummary");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)pipelineExecutionSummary.pipelineExecutionId(), PIPELINEEXECUTIONID_BINDING);
            protocolMarshaller.marshall((Object)pipelineExecutionSummary.statusAsString(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)pipelineExecutionSummary.startTime(), STARTTIME_BINDING);
            protocolMarshaller.marshall((Object)pipelineExecutionSummary.lastUpdateTime(), LASTUPDATETIME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

