/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codegurusecurity;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.codegurusecurity.CodeGuruSecurityAsyncClient;
import software.amazon.awssdk.services.codegurusecurity.CodeGuruSecurityServiceClientConfiguration;
import software.amazon.awssdk.services.codegurusecurity.model.AccessDeniedException;
import software.amazon.awssdk.services.codegurusecurity.model.BatchGetFindingsRequest;
import software.amazon.awssdk.services.codegurusecurity.model.BatchGetFindingsResponse;
import software.amazon.awssdk.services.codegurusecurity.model.CodeGuruSecurityException;
import software.amazon.awssdk.services.codegurusecurity.model.CodeGuruSecurityRequest;
import software.amazon.awssdk.services.codegurusecurity.model.ConflictException;
import software.amazon.awssdk.services.codegurusecurity.model.CreateScanRequest;
import software.amazon.awssdk.services.codegurusecurity.model.CreateScanResponse;
import software.amazon.awssdk.services.codegurusecurity.model.CreateUploadUrlRequest;
import software.amazon.awssdk.services.codegurusecurity.model.CreateUploadUrlResponse;
import software.amazon.awssdk.services.codegurusecurity.model.GetAccountConfigurationRequest;
import software.amazon.awssdk.services.codegurusecurity.model.GetAccountConfigurationResponse;
import software.amazon.awssdk.services.codegurusecurity.model.GetFindingsRequest;
import software.amazon.awssdk.services.codegurusecurity.model.GetFindingsResponse;
import software.amazon.awssdk.services.codegurusecurity.model.GetMetricsSummaryRequest;
import software.amazon.awssdk.services.codegurusecurity.model.GetMetricsSummaryResponse;
import software.amazon.awssdk.services.codegurusecurity.model.GetScanRequest;
import software.amazon.awssdk.services.codegurusecurity.model.GetScanResponse;
import software.amazon.awssdk.services.codegurusecurity.model.InternalServerException;
import software.amazon.awssdk.services.codegurusecurity.model.ListFindingsMetricsRequest;
import software.amazon.awssdk.services.codegurusecurity.model.ListFindingsMetricsResponse;
import software.amazon.awssdk.services.codegurusecurity.model.ListScansRequest;
import software.amazon.awssdk.services.codegurusecurity.model.ListScansResponse;
import software.amazon.awssdk.services.codegurusecurity.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.codegurusecurity.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.codegurusecurity.model.ResourceNotFoundException;
import software.amazon.awssdk.services.codegurusecurity.model.TagResourceRequest;
import software.amazon.awssdk.services.codegurusecurity.model.TagResourceResponse;
import software.amazon.awssdk.services.codegurusecurity.model.ThrottlingException;
import software.amazon.awssdk.services.codegurusecurity.model.UntagResourceRequest;
import software.amazon.awssdk.services.codegurusecurity.model.UntagResourceResponse;
import software.amazon.awssdk.services.codegurusecurity.model.UpdateAccountConfigurationRequest;
import software.amazon.awssdk.services.codegurusecurity.model.UpdateAccountConfigurationResponse;
import software.amazon.awssdk.services.codegurusecurity.model.ValidationException;
import software.amazon.awssdk.services.codegurusecurity.paginators.GetFindingsPublisher;
import software.amazon.awssdk.services.codegurusecurity.paginators.ListFindingsMetricsPublisher;
import software.amazon.awssdk.services.codegurusecurity.paginators.ListScansPublisher;
import software.amazon.awssdk.services.codegurusecurity.transform.BatchGetFindingsRequestMarshaller;
import software.amazon.awssdk.services.codegurusecurity.transform.CreateScanRequestMarshaller;
import software.amazon.awssdk.services.codegurusecurity.transform.CreateUploadUrlRequestMarshaller;
import software.amazon.awssdk.services.codegurusecurity.transform.GetAccountConfigurationRequestMarshaller;
import software.amazon.awssdk.services.codegurusecurity.transform.GetFindingsRequestMarshaller;
import software.amazon.awssdk.services.codegurusecurity.transform.GetMetricsSummaryRequestMarshaller;
import software.amazon.awssdk.services.codegurusecurity.transform.GetScanRequestMarshaller;
import software.amazon.awssdk.services.codegurusecurity.transform.ListFindingsMetricsRequestMarshaller;
import software.amazon.awssdk.services.codegurusecurity.transform.ListScansRequestMarshaller;
import software.amazon.awssdk.services.codegurusecurity.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.codegurusecurity.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.codegurusecurity.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.codegurusecurity.transform.UpdateAccountConfigurationRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkInternalApi
final class DefaultCodeGuruSecurityAsyncClient
implements CodeGuruSecurityAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultCodeGuruSecurityAsyncClient.class);
    private final AsyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;
    private final CodeGuruSecurityServiceClientConfiguration serviceClientConfiguration;

    protected DefaultCodeGuruSecurityAsyncClient(CodeGuruSecurityServiceClientConfiguration serviceClientConfiguration, SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.serviceClientConfiguration = serviceClientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    @Override
    public CompletableFuture<BatchGetFindingsResponse> batchGetFindings(BatchGetFindingsRequest batchGetFindingsRequest) {
        List<MetricPublisher> metricPublishers = DefaultCodeGuruSecurityAsyncClient.resolveMetricPublishers(this.clientConfiguration, batchGetFindingsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeGuru Security");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchGetFindings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchGetFindingsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchGetFindings").withMarshaller((Marshaller)new BatchGetFindingsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)batchGetFindingsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeGuruSecurityAsyncClient.lambda$batchGetFindings$1(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeGuruSecurityAsyncClient.lambda$batchGetFindings$2((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateScanResponse> createScan(CreateScanRequest createScanRequest) {
        List<MetricPublisher> metricPublishers = DefaultCodeGuruSecurityAsyncClient.resolveMetricPublishers(this.clientConfiguration, createScanRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeGuru Security");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateScan");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateScanResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateScan").withMarshaller((Marshaller)new CreateScanRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createScanRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeGuruSecurityAsyncClient.lambda$createScan$4(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeGuruSecurityAsyncClient.lambda$createScan$5((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateUploadUrlResponse> createUploadUrl(CreateUploadUrlRequest createUploadUrlRequest) {
        List<MetricPublisher> metricPublishers = DefaultCodeGuruSecurityAsyncClient.resolveMetricPublishers(this.clientConfiguration, createUploadUrlRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeGuru Security");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateUploadUrl");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateUploadUrlResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateUploadUrl").withMarshaller((Marshaller)new CreateUploadUrlRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createUploadUrlRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeGuruSecurityAsyncClient.lambda$createUploadUrl$7(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeGuruSecurityAsyncClient.lambda$createUploadUrl$8((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetAccountConfigurationResponse> getAccountConfiguration(GetAccountConfigurationRequest getAccountConfigurationRequest) {
        List<MetricPublisher> metricPublishers = DefaultCodeGuruSecurityAsyncClient.resolveMetricPublishers(this.clientConfiguration, getAccountConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeGuru Security");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetAccountConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetAccountConfigurationResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAccountConfiguration").withMarshaller((Marshaller)new GetAccountConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getAccountConfigurationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeGuruSecurityAsyncClient.lambda$getAccountConfiguration$10(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeGuruSecurityAsyncClient.lambda$getAccountConfiguration$11((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetFindingsResponse> getFindings(GetFindingsRequest getFindingsRequest) {
        List<MetricPublisher> metricPublishers = DefaultCodeGuruSecurityAsyncClient.resolveMetricPublishers(this.clientConfiguration, getFindingsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeGuru Security");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetFindings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetFindingsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetFindings").withMarshaller((Marshaller)new GetFindingsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getFindingsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeGuruSecurityAsyncClient.lambda$getFindings$13(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeGuruSecurityAsyncClient.lambda$getFindings$14((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public GetFindingsPublisher getFindingsPaginator(GetFindingsRequest getFindingsRequest) {
        return new GetFindingsPublisher(this, this.applyPaginatorUserAgent(getFindingsRequest));
    }

    @Override
    public CompletableFuture<GetMetricsSummaryResponse> getMetricsSummary(GetMetricsSummaryRequest getMetricsSummaryRequest) {
        List<MetricPublisher> metricPublishers = DefaultCodeGuruSecurityAsyncClient.resolveMetricPublishers(this.clientConfiguration, getMetricsSummaryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeGuru Security");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetMetricsSummary");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetMetricsSummaryResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetMetricsSummary").withMarshaller((Marshaller)new GetMetricsSummaryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getMetricsSummaryRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeGuruSecurityAsyncClient.lambda$getMetricsSummary$16(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeGuruSecurityAsyncClient.lambda$getMetricsSummary$17((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetScanResponse> getScan(GetScanRequest getScanRequest) {
        List<MetricPublisher> metricPublishers = DefaultCodeGuruSecurityAsyncClient.resolveMetricPublishers(this.clientConfiguration, getScanRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeGuru Security");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetScan");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetScanResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetScan").withMarshaller((Marshaller)new GetScanRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getScanRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeGuruSecurityAsyncClient.lambda$getScan$19(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeGuruSecurityAsyncClient.lambda$getScan$20((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListFindingsMetricsResponse> listFindingsMetrics(ListFindingsMetricsRequest listFindingsMetricsRequest) {
        List<MetricPublisher> metricPublishers = DefaultCodeGuruSecurityAsyncClient.resolveMetricPublishers(this.clientConfiguration, listFindingsMetricsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeGuru Security");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListFindingsMetrics");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListFindingsMetricsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListFindingsMetrics").withMarshaller((Marshaller)new ListFindingsMetricsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listFindingsMetricsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeGuruSecurityAsyncClient.lambda$listFindingsMetrics$22(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeGuruSecurityAsyncClient.lambda$listFindingsMetrics$23((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public ListFindingsMetricsPublisher listFindingsMetricsPaginator(ListFindingsMetricsRequest listFindingsMetricsRequest) {
        return new ListFindingsMetricsPublisher(this, this.applyPaginatorUserAgent(listFindingsMetricsRequest));
    }

    @Override
    public CompletableFuture<ListScansResponse> listScans(ListScansRequest listScansRequest) {
        List<MetricPublisher> metricPublishers = DefaultCodeGuruSecurityAsyncClient.resolveMetricPublishers(this.clientConfiguration, listScansRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeGuru Security");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListScans");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListScansResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListScans").withMarshaller((Marshaller)new ListScansRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listScansRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeGuruSecurityAsyncClient.lambda$listScans$25(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeGuruSecurityAsyncClient.lambda$listScans$26((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public ListScansPublisher listScansPaginator(ListScansRequest listScansRequest) {
        return new ListScansPublisher(this, this.applyPaginatorUserAgent(listScansRequest));
    }

    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        List<MetricPublisher> metricPublishers = DefaultCodeGuruSecurityAsyncClient.resolveMetricPublishers(this.clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeGuru Security");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listTagsForResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeGuruSecurityAsyncClient.lambda$listTagsForResource$28(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeGuruSecurityAsyncClient.lambda$listTagsForResource$29((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        List<MetricPublisher> metricPublishers = DefaultCodeGuruSecurityAsyncClient.resolveMetricPublishers(this.clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeGuru Security");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)tagResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeGuruSecurityAsyncClient.lambda$tagResource$31(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeGuruSecurityAsyncClient.lambda$tagResource$32((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        List<MetricPublisher> metricPublishers = DefaultCodeGuruSecurityAsyncClient.resolveMetricPublishers(this.clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeGuru Security");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)untagResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeGuruSecurityAsyncClient.lambda$untagResource$34(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeGuruSecurityAsyncClient.lambda$untagResource$35((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateAccountConfigurationResponse> updateAccountConfiguration(UpdateAccountConfigurationRequest updateAccountConfigurationRequest) {
        List<MetricPublisher> metricPublishers = DefaultCodeGuruSecurityAsyncClient.resolveMetricPublishers(this.clientConfiguration, updateAccountConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeGuru Security");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateAccountConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateAccountConfigurationResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateAccountConfiguration").withMarshaller((Marshaller)new UpdateAccountConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateAccountConfigurationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeGuruSecurityAsyncClient.lambda$updateAccountConfiguration$37(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeGuruSecurityAsyncClient.lambda$updateAccountConfiguration$38((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public final CodeGuruSecurityServiceClientConfiguration serviceClientConfiguration() {
        return this.serviceClientConfiguration;
    }

    public final String serviceName() {
        return "codeguru-security";
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(CodeGuruSecurityException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("AccessDeniedException").exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(Integer.valueOf(403)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ConflictException").exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ThrottlingException").exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(Integer.valueOf(429)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ValidationException").exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalServerException").exceptionBuilderSupplier(InternalServerException::builder).httpStatusCode(Integer.valueOf(500)).build());
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private <T extends CodeGuruSecurityRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.20.87").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((CodeGuruSecurityRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updateAccountConfiguration$38(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateAccountConfiguration$37(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateAccountConfigurationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$untagResource$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$34(List metricPublishers, MetricCollector apiCallMetricCollector, UntagResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$tagResource$32(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$31(List metricPublishers, MetricCollector apiCallMetricCollector, TagResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listTagsForResource$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$28(List metricPublishers, MetricCollector apiCallMetricCollector, ListTagsForResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listScans$26(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listScans$25(List metricPublishers, MetricCollector apiCallMetricCollector, ListScansResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listFindingsMetrics$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listFindingsMetrics$22(List metricPublishers, MetricCollector apiCallMetricCollector, ListFindingsMetricsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getScan$20(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getScan$19(List metricPublishers, MetricCollector apiCallMetricCollector, GetScanResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getMetricsSummary$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getMetricsSummary$16(List metricPublishers, MetricCollector apiCallMetricCollector, GetMetricsSummaryResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getFindings$14(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getFindings$13(List metricPublishers, MetricCollector apiCallMetricCollector, GetFindingsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getAccountConfiguration$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getAccountConfiguration$10(List metricPublishers, MetricCollector apiCallMetricCollector, GetAccountConfigurationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createUploadUrl$8(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createUploadUrl$7(List metricPublishers, MetricCollector apiCallMetricCollector, CreateUploadUrlResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createScan$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createScan$4(List metricPublishers, MetricCollector apiCallMetricCollector, CreateScanResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$batchGetFindings$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchGetFindings$1(List metricPublishers, MetricCollector apiCallMetricCollector, BatchGetFindingsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }
}

