/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codegurureviewer.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.codegurureviewer.CodeGuruReviewerClient;
import software.amazon.awssdk.services.codegurureviewer.internal.UserAgentUtils;
import software.amazon.awssdk.services.codegurureviewer.model.ListRecommendationFeedbackRequest;
import software.amazon.awssdk.services.codegurureviewer.model.ListRecommendationFeedbackResponse;

public class ListRecommendationFeedbackIterable
implements SdkIterable<ListRecommendationFeedbackResponse> {
    private final CodeGuruReviewerClient client;
    private final ListRecommendationFeedbackRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListRecommendationFeedbackIterable(CodeGuruReviewerClient client, ListRecommendationFeedbackRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListRecommendationFeedbackResponseFetcher();
    }

    public Iterator<ListRecommendationFeedbackResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListRecommendationFeedbackResponseFetcher
    implements SyncPageFetcher<ListRecommendationFeedbackResponse> {
        private ListRecommendationFeedbackResponseFetcher() {
        }

        public boolean hasNextPage(ListRecommendationFeedbackResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListRecommendationFeedbackResponse nextPage(ListRecommendationFeedbackResponse previousPage) {
            if (previousPage == null) {
                return ListRecommendationFeedbackIterable.this.client.listRecommendationFeedback(ListRecommendationFeedbackIterable.this.firstRequest);
            }
            return ListRecommendationFeedbackIterable.this.client.listRecommendationFeedback((ListRecommendationFeedbackRequest)((Object)ListRecommendationFeedbackIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

