/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codegurureviewer.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codegurureviewer.model.CodeArtifacts;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3RepositoryDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, S3RepositoryDetails> {
    private static final SdkField<String> BUCKET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BucketName").getter(S3RepositoryDetails.getter(S3RepositoryDetails::bucketName)).setter(S3RepositoryDetails.setter(Builder::bucketName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BucketName").build()}).build();
    private static final SdkField<CodeArtifacts> CODE_ARTIFACTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CodeArtifacts").getter(S3RepositoryDetails.getter(S3RepositoryDetails::codeArtifacts)).setter(S3RepositoryDetails.setter(Builder::codeArtifacts)).constructor(CodeArtifacts::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CodeArtifacts").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_NAME_FIELD, CODE_ARTIFACTS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String bucketName;
    private final CodeArtifacts codeArtifacts;

    private S3RepositoryDetails(BuilderImpl builder) {
        this.bucketName = builder.bucketName;
        this.codeArtifacts = builder.codeArtifacts;
    }

    public final String bucketName() {
        return this.bucketName;
    }

    public final CodeArtifacts codeArtifacts() {
        return this.codeArtifacts;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bucketName());
        hashCode = 31 * hashCode + Objects.hashCode(this.codeArtifacts());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3RepositoryDetails)) {
            return false;
        }
        S3RepositoryDetails other = (S3RepositoryDetails)obj;
        return Objects.equals(this.bucketName(), other.bucketName()) && Objects.equals(this.codeArtifacts(), other.codeArtifacts());
    }

    public final String toString() {
        return ToString.builder((String)"S3RepositoryDetails").add("BucketName", (Object)this.bucketName()).add("CodeArtifacts", (Object)this.codeArtifacts()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BucketName": {
                return Optional.ofNullable(clazz.cast(this.bucketName()));
            }
            case "CodeArtifacts": {
                return Optional.ofNullable(clazz.cast(this.codeArtifacts()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<S3RepositoryDetails, T> g) {
        return obj -> g.apply((S3RepositoryDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String bucketName;
        private CodeArtifacts codeArtifacts;

        private BuilderImpl() {
        }

        private BuilderImpl(S3RepositoryDetails model) {
            this.bucketName(model.bucketName);
            this.codeArtifacts(model.codeArtifacts);
        }

        public final String getBucketName() {
            return this.bucketName;
        }

        public final void setBucketName(String bucketName) {
            this.bucketName = bucketName;
        }

        @Override
        @Transient
        public final Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public final CodeArtifacts.Builder getCodeArtifacts() {
            return this.codeArtifacts != null ? this.codeArtifacts.toBuilder() : null;
        }

        public final void setCodeArtifacts(CodeArtifacts.BuilderImpl codeArtifacts) {
            this.codeArtifacts = codeArtifacts != null ? codeArtifacts.build() : null;
        }

        @Override
        @Transient
        public final Builder codeArtifacts(CodeArtifacts codeArtifacts) {
            this.codeArtifacts = codeArtifacts;
            return this;
        }

        public S3RepositoryDetails build() {
            return new S3RepositoryDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, S3RepositoryDetails> {
        public Builder bucketName(String var1);

        public Builder codeArtifacts(CodeArtifacts var1);

        default public Builder codeArtifacts(Consumer<CodeArtifacts.Builder> codeArtifacts) {
            return this.codeArtifacts((CodeArtifacts)((CodeArtifacts.Builder)CodeArtifacts.builder().applyMutation(codeArtifacts)).build());
        }
    }
}

