/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codeguruprofiler.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A set of rules used to make a recommendation during an analysis.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Pattern implements SdkPojo, Serializable, ToCopyableBuilder<Pattern.Builder, Pattern> {
    private static final SdkField<List<String>> COUNTERS_TO_AGGREGATE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("countersToAggregate")
            .getter(getter(Pattern::countersToAggregate))
            .setter(setter(Builder::countersToAggregate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("countersToAggregate").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(Pattern::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(Pattern::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(Pattern::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> RESOLUTION_STEPS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resolutionSteps").getter(getter(Pattern::resolutionSteps)).setter(setter(Builder::resolutionSteps))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resolutionSteps").build()).build();

    private static final SdkField<List<List<String>>> TARGET_FRAMES_FIELD = SdkField
            .<List<List<String>>> builder(MarshallingType.LIST)
            .memberName("targetFrames")
            .getter(getter(Pattern::targetFrames))
            .setter(setter(Builder::targetFrames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetFrames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<List<String>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<String> builder(MarshallingType.STRING)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final SdkField<Double> THRESHOLD_PERCENT_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("thresholdPercent").getter(getter(Pattern::thresholdPercent)).setter(setter(Builder::thresholdPercent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thresholdPercent").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COUNTERS_TO_AGGREGATE_FIELD,
            DESCRIPTION_FIELD, ID_FIELD, NAME_FIELD, RESOLUTION_STEPS_FIELD, TARGET_FRAMES_FIELD, THRESHOLD_PERCENT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> countersToAggregate;

    private final String description;

    private final String id;

    private final String name;

    private final String resolutionSteps;

    private final List<List<String>> targetFrames;

    private final Double thresholdPercent;

    private Pattern(BuilderImpl builder) {
        this.countersToAggregate = builder.countersToAggregate;
        this.description = builder.description;
        this.id = builder.id;
        this.name = builder.name;
        this.resolutionSteps = builder.resolutionSteps;
        this.targetFrames = builder.targetFrames;
        this.thresholdPercent = builder.thresholdPercent;
    }

    /**
     * For responses, this returns true if the service returned a value for the CountersToAggregate property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCountersToAggregate() {
        return countersToAggregate != null && !(countersToAggregate instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the different counters used to determine if there is a match.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCountersToAggregate} method.
     * </p>
     * 
     * @return A list of the different counters used to determine if there is a match.
     */
    public final List<String> countersToAggregate() {
        return countersToAggregate;
    }

    /**
     * <p>
     * The description of the recommendation. This explains a potential inefficiency in a profiled application.
     * </p>
     * 
     * @return The description of the recommendation. This explains a potential inefficiency in a profiled application.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The universally unique identifier (UUID) of this pattern.
     * </p>
     * 
     * @return The universally unique identifier (UUID) of this pattern.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The name for this pattern.
     * </p>
     * 
     * @return The name for this pattern.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A string that contains the steps recommended to address the potential inefficiency.
     * </p>
     * 
     * @return A string that contains the steps recommended to address the potential inefficiency.
     */
    public final String resolutionSteps() {
        return resolutionSteps;
    }

    /**
     * For responses, this returns true if the service returned a value for the TargetFrames property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTargetFrames() {
        return targetFrames != null && !(targetFrames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of frame names that were searched during the analysis that generated a recommendation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTargetFrames} method.
     * </p>
     * 
     * @return A list of frame names that were searched during the analysis that generated a recommendation.
     */
    public final List<List<String>> targetFrames() {
        return targetFrames;
    }

    /**
     * <p>
     * The percentage of time an application spends in one method that triggers a recommendation. The percentage of time
     * is the same as the percentage of the total gathered sample counts during analysis.
     * </p>
     * 
     * @return The percentage of time an application spends in one method that triggers a recommendation. The percentage
     *         of time is the same as the percentage of the total gathered sample counts during analysis.
     */
    public final Double thresholdPercent() {
        return thresholdPercent;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasCountersToAggregate() ? countersToAggregate() : null);
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(resolutionSteps());
        hashCode = 31 * hashCode + Objects.hashCode(hasTargetFrames() ? targetFrames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(thresholdPercent());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Pattern)) {
            return false;
        }
        Pattern other = (Pattern) obj;
        return hasCountersToAggregate() == other.hasCountersToAggregate()
                && Objects.equals(countersToAggregate(), other.countersToAggregate())
                && Objects.equals(description(), other.description()) && Objects.equals(id(), other.id())
                && Objects.equals(name(), other.name()) && Objects.equals(resolutionSteps(), other.resolutionSteps())
                && hasTargetFrames() == other.hasTargetFrames() && Objects.equals(targetFrames(), other.targetFrames())
                && Objects.equals(thresholdPercent(), other.thresholdPercent());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Pattern").add("CountersToAggregate", hasCountersToAggregate() ? countersToAggregate() : null)
                .add("Description", description()).add("Id", id()).add("Name", name()).add("ResolutionSteps", resolutionSteps())
                .add("TargetFrames", hasTargetFrames() ? targetFrames() : null).add("ThresholdPercent", thresholdPercent())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "countersToAggregate":
            return Optional.ofNullable(clazz.cast(countersToAggregate()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "resolutionSteps":
            return Optional.ofNullable(clazz.cast(resolutionSteps()));
        case "targetFrames":
            return Optional.ofNullable(clazz.cast(targetFrames()));
        case "thresholdPercent":
            return Optional.ofNullable(clazz.cast(thresholdPercent()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("countersToAggregate", COUNTERS_TO_AGGREGATE_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("id", ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("resolutionSteps", RESOLUTION_STEPS_FIELD);
        map.put("targetFrames", TARGET_FRAMES_FIELD);
        map.put("thresholdPercent", THRESHOLD_PERCENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Pattern, T> g) {
        return obj -> g.apply((Pattern) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Pattern> {
        /**
         * <p>
         * A list of the different counters used to determine if there is a match.
         * </p>
         * 
         * @param countersToAggregate
         *        A list of the different counters used to determine if there is a match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder countersToAggregate(Collection<String> countersToAggregate);

        /**
         * <p>
         * A list of the different counters used to determine if there is a match.
         * </p>
         * 
         * @param countersToAggregate
         *        A list of the different counters used to determine if there is a match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder countersToAggregate(String... countersToAggregate);

        /**
         * <p>
         * The description of the recommendation. This explains a potential inefficiency in a profiled application.
         * </p>
         * 
         * @param description
         *        The description of the recommendation. This explains a potential inefficiency in a profiled
         *        application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The universally unique identifier (UUID) of this pattern.
         * </p>
         * 
         * @param id
         *        The universally unique identifier (UUID) of this pattern.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The name for this pattern.
         * </p>
         * 
         * @param name
         *        The name for this pattern.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A string that contains the steps recommended to address the potential inefficiency.
         * </p>
         * 
         * @param resolutionSteps
         *        A string that contains the steps recommended to address the potential inefficiency.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resolutionSteps(String resolutionSteps);

        /**
         * <p>
         * A list of frame names that were searched during the analysis that generated a recommendation.
         * </p>
         * 
         * @param targetFrames
         *        A list of frame names that were searched during the analysis that generated a recommendation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetFrames(Collection<? extends Collection<String>> targetFrames);

        /**
         * <p>
         * A list of frame names that were searched during the analysis that generated a recommendation.
         * </p>
         * 
         * @param targetFrames
         *        A list of frame names that were searched during the analysis that generated a recommendation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetFrames(Collection<String>... targetFrames);

        /**
         * <p>
         * The percentage of time an application spends in one method that triggers a recommendation. The percentage of
         * time is the same as the percentage of the total gathered sample counts during analysis.
         * </p>
         * 
         * @param thresholdPercent
         *        The percentage of time an application spends in one method that triggers a recommendation. The
         *        percentage of time is the same as the percentage of the total gathered sample counts during analysis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thresholdPercent(Double thresholdPercent);
    }

    static final class BuilderImpl implements Builder {
        private List<String> countersToAggregate = DefaultSdkAutoConstructList.getInstance();

        private String description;

        private String id;

        private String name;

        private String resolutionSteps;

        private List<List<String>> targetFrames = DefaultSdkAutoConstructList.getInstance();

        private Double thresholdPercent;

        private BuilderImpl() {
        }

        private BuilderImpl(Pattern model) {
            countersToAggregate(model.countersToAggregate);
            description(model.description);
            id(model.id);
            name(model.name);
            resolutionSteps(model.resolutionSteps);
            targetFrames(model.targetFrames);
            thresholdPercent(model.thresholdPercent);
        }

        public final Collection<String> getCountersToAggregate() {
            if (countersToAggregate instanceof SdkAutoConstructList) {
                return null;
            }
            return countersToAggregate;
        }

        public final void setCountersToAggregate(Collection<String> countersToAggregate) {
            this.countersToAggregate = StringsCopier.copy(countersToAggregate);
        }

        @Override
        public final Builder countersToAggregate(Collection<String> countersToAggregate) {
            this.countersToAggregate = StringsCopier.copy(countersToAggregate);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder countersToAggregate(String... countersToAggregate) {
            countersToAggregate(Arrays.asList(countersToAggregate));
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getResolutionSteps() {
            return resolutionSteps;
        }

        public final void setResolutionSteps(String resolutionSteps) {
            this.resolutionSteps = resolutionSteps;
        }

        @Override
        public final Builder resolutionSteps(String resolutionSteps) {
            this.resolutionSteps = resolutionSteps;
            return this;
        }

        public final Collection<? extends Collection<String>> getTargetFrames() {
            if (targetFrames instanceof SdkAutoConstructList) {
                return null;
            }
            return targetFrames;
        }

        public final void setTargetFrames(Collection<? extends Collection<String>> targetFrames) {
            this.targetFrames = TargetFramesCopier.copy(targetFrames);
        }

        @Override
        public final Builder targetFrames(Collection<? extends Collection<String>> targetFrames) {
            this.targetFrames = TargetFramesCopier.copy(targetFrames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetFrames(Collection<String>... targetFrames) {
            targetFrames(Arrays.asList(targetFrames));
            return this;
        }

        public final Double getThresholdPercent() {
            return thresholdPercent;
        }

        public final void setThresholdPercent(Double thresholdPercent) {
            this.thresholdPercent = thresholdPercent;
        }

        @Override
        public final Builder thresholdPercent(Double thresholdPercent) {
            this.thresholdPercent = thresholdPercent;
            return this;
        }

        @Override
        public Pattern build() {
            return new Pattern(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
