/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codeguruprofiler.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The structure representing the listProfileTimesRequest.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListProfileTimesRequest extends CodeGuruProfilerRequest implements
        ToCopyableBuilder<ListProfileTimesRequest.Builder, ListProfileTimesRequest> {
    private static final SdkField<Instant> END_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("endTime")
            .getter(getter(ListProfileTimesRequest::endTime))
            .setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("endTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListProfileTimesRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListProfileTimesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<String> ORDER_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("orderBy").getter(getter(ListProfileTimesRequest::orderByAsString)).setter(setter(Builder::orderBy))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("orderBy").build()).build();

    private static final SdkField<String> PERIOD_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("period")
            .getter(getter(ListProfileTimesRequest::periodAsString)).setter(setter(Builder::period))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("period").build()).build();

    private static final SdkField<String> PROFILING_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("profilingGroupName").getter(getter(ListProfileTimesRequest::profilingGroupName))
            .setter(setter(Builder::profilingGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("profilingGroupName").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("startTime")
            .getter(getter(ListProfileTimesRequest::startTime))
            .setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("startTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(END_TIME_FIELD,
            MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, ORDER_BY_FIELD, PERIOD_FIELD, PROFILING_GROUP_NAME_FIELD, START_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Instant endTime;

    private final Integer maxResults;

    private final String nextToken;

    private final String orderBy;

    private final String period;

    private final String profilingGroupName;

    private final Instant startTime;

    private ListProfileTimesRequest(BuilderImpl builder) {
        super(builder);
        this.endTime = builder.endTime;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.orderBy = builder.orderBy;
        this.period = builder.period;
        this.profilingGroupName = builder.profilingGroupName;
        this.startTime = builder.startTime;
    }

    /**
     * <p>
     * The end time of the time range from which to list the profiles.
     * </p>
     * 
     * @return The end time of the time range from which to list the profiles.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * The maximum number of profile time results returned by <code>ListProfileTimes</code> in paginated output. When
     * this parameter is used, <code>ListProfileTimes</code> only returns <code>maxResults</code> results in a single
     * page with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by
     * sending another <code>ListProfileTimes</code> request with the returned <code>nextToken</code> value.
     * </p>
     * 
     * @return The maximum number of profile time results returned by <code>ListProfileTimes</code> in paginated output.
     *         When this parameter is used, <code>ListProfileTimes</code> only returns <code>maxResults</code> results
     *         in a single page with a <code>nextToken</code> response element. The remaining results of the initial
     *         request can be seen by sending another <code>ListProfileTimes</code> request with the returned
     *         <code>nextToken</code> value.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The <code>nextToken</code> value returned from a previous paginated <code>ListProfileTimes</code> request where
     * <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from
     * the end of the previous results that returned the <code>nextToken</code> value.
     * </p>
     * <note>
     * <p>
     * This token should be treated as an opaque identifier that is only used to retrieve the next items in a list and
     * not for other programmatic purposes.
     * </p>
     * </note>
     * 
     * @return The <code>nextToken</code> value returned from a previous paginated <code>ListProfileTimes</code> request
     *         where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination
     *         continues from the end of the previous results that returned the <code>nextToken</code> value. </p>
     *         <note>
     *         <p>
     *         This token should be treated as an opaque identifier that is only used to retrieve the next items in a
     *         list and not for other programmatic purposes.
     *         </p>
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The order (ascending or descending by start time of the profile) to use when listing profiles. Defaults to
     * <code>TIMESTAMP_DESCENDING</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #orderBy} will
     * return {@link OrderBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #orderByAsString}.
     * </p>
     * 
     * @return The order (ascending or descending by start time of the profile) to use when listing profiles. Defaults
     *         to <code>TIMESTAMP_DESCENDING</code>.
     * @see OrderBy
     */
    public final OrderBy orderBy() {
        return OrderBy.fromValue(orderBy);
    }

    /**
     * <p>
     * The order (ascending or descending by start time of the profile) to use when listing profiles. Defaults to
     * <code>TIMESTAMP_DESCENDING</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #orderBy} will
     * return {@link OrderBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #orderByAsString}.
     * </p>
     * 
     * @return The order (ascending or descending by start time of the profile) to use when listing profiles. Defaults
     *         to <code>TIMESTAMP_DESCENDING</code>.
     * @see OrderBy
     */
    public final String orderByAsString() {
        return orderBy;
    }

    /**
     * <p>
     * The aggregation period. This specifies the period during which an aggregation profile collects posted agent
     * profiles for a profiling group. There are 3 valid values.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>P1D</code> — 1 day
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PT1H</code> — 1 hour
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PT5M</code> — 5 minutes
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #period} will
     * return {@link AggregationPeriod#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #periodAsString}.
     * </p>
     * 
     * @return The aggregation period. This specifies the period during which an aggregation profile collects posted
     *         agent profiles for a profiling group. There are 3 valid values. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>P1D</code> — 1 day
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PT1H</code> — 1 hour
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PT5M</code> — 5 minutes
     *         </p>
     *         </li>
     * @see AggregationPeriod
     */
    public final AggregationPeriod period() {
        return AggregationPeriod.fromValue(period);
    }

    /**
     * <p>
     * The aggregation period. This specifies the period during which an aggregation profile collects posted agent
     * profiles for a profiling group. There are 3 valid values.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>P1D</code> — 1 day
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PT1H</code> — 1 hour
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PT5M</code> — 5 minutes
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #period} will
     * return {@link AggregationPeriod#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #periodAsString}.
     * </p>
     * 
     * @return The aggregation period. This specifies the period during which an aggregation profile collects posted
     *         agent profiles for a profiling group. There are 3 valid values. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>P1D</code> — 1 day
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PT1H</code> — 1 hour
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PT5M</code> — 5 minutes
     *         </p>
     *         </li>
     * @see AggregationPeriod
     */
    public final String periodAsString() {
        return period;
    }

    /**
     * <p>
     * The name of the profiling group.
     * </p>
     * 
     * @return The name of the profiling group.
     */
    public final String profilingGroupName() {
        return profilingGroupName;
    }

    /**
     * <p>
     * The start time of the time range from which to list the profiles.
     * </p>
     * 
     * @return The start time of the time range from which to list the profiles.
     */
    public final Instant startTime() {
        return startTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(orderByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(periodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(profilingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListProfileTimesRequest)) {
            return false;
        }
        ListProfileTimesRequest other = (ListProfileTimesRequest) obj;
        return Objects.equals(endTime(), other.endTime()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(orderByAsString(), other.orderByAsString())
                && Objects.equals(periodAsString(), other.periodAsString())
                && Objects.equals(profilingGroupName(), other.profilingGroupName())
                && Objects.equals(startTime(), other.startTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListProfileTimesRequest").add("EndTime", endTime()).add("MaxResults", maxResults())
                .add("NextToken", nextToken()).add("OrderBy", orderByAsString()).add("Period", periodAsString())
                .add("ProfilingGroupName", profilingGroupName()).add("StartTime", startTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "endTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "orderBy":
            return Optional.ofNullable(clazz.cast(orderByAsString()));
        case "period":
            return Optional.ofNullable(clazz.cast(periodAsString()));
        case "profilingGroupName":
            return Optional.ofNullable(clazz.cast(profilingGroupName()));
        case "startTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("endTime", END_TIME_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("orderBy", ORDER_BY_FIELD);
        map.put("period", PERIOD_FIELD);
        map.put("profilingGroupName", PROFILING_GROUP_NAME_FIELD);
        map.put("startTime", START_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListProfileTimesRequest, T> g) {
        return obj -> g.apply((ListProfileTimesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CodeGuruProfilerRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListProfileTimesRequest> {
        /**
         * <p>
         * The end time of the time range from which to list the profiles.
         * </p>
         * 
         * @param endTime
         *        The end time of the time range from which to list the profiles.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * The maximum number of profile time results returned by <code>ListProfileTimes</code> in paginated output.
         * When this parameter is used, <code>ListProfileTimes</code> only returns <code>maxResults</code> results in a
         * single page with a <code>nextToken</code> response element. The remaining results of the initial request can
         * be seen by sending another <code>ListProfileTimes</code> request with the returned <code>nextToken</code>
         * value.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of profile time results returned by <code>ListProfileTimes</code> in paginated
         *        output. When this parameter is used, <code>ListProfileTimes</code> only returns
         *        <code>maxResults</code> results in a single page with a <code>nextToken</code> response element. The
         *        remaining results of the initial request can be seen by sending another <code>ListProfileTimes</code>
         *        request with the returned <code>nextToken</code> value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The <code>nextToken</code> value returned from a previous paginated <code>ListProfileTimes</code> request
         * where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination
         * continues from the end of the previous results that returned the <code>nextToken</code> value.
         * </p>
         * <note>
         * <p>
         * This token should be treated as an opaque identifier that is only used to retrieve the next items in a list
         * and not for other programmatic purposes.
         * </p>
         * </note>
         * 
         * @param nextToken
         *        The <code>nextToken</code> value returned from a previous paginated <code>ListProfileTimes</code>
         *        request where <code>maxResults</code> was used and the results exceeded the value of that parameter.
         *        Pagination continues from the end of the previous results that returned the <code>nextToken</code>
         *        value. </p> <note>
         *        <p>
         *        This token should be treated as an opaque identifier that is only used to retrieve the next items in a
         *        list and not for other programmatic purposes.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The order (ascending or descending by start time of the profile) to use when listing profiles. Defaults to
         * <code>TIMESTAMP_DESCENDING</code>.
         * </p>
         * 
         * @param orderBy
         *        The order (ascending or descending by start time of the profile) to use when listing profiles.
         *        Defaults to <code>TIMESTAMP_DESCENDING</code>.
         * @see OrderBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OrderBy
         */
        Builder orderBy(String orderBy);

        /**
         * <p>
         * The order (ascending or descending by start time of the profile) to use when listing profiles. Defaults to
         * <code>TIMESTAMP_DESCENDING</code>.
         * </p>
         * 
         * @param orderBy
         *        The order (ascending or descending by start time of the profile) to use when listing profiles.
         *        Defaults to <code>TIMESTAMP_DESCENDING</code>.
         * @see OrderBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OrderBy
         */
        Builder orderBy(OrderBy orderBy);

        /**
         * <p>
         * The aggregation period. This specifies the period during which an aggregation profile collects posted agent
         * profiles for a profiling group. There are 3 valid values.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>P1D</code> — 1 day
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PT1H</code> — 1 hour
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PT5M</code> — 5 minutes
         * </p>
         * </li>
         * </ul>
         * 
         * @param period
         *        The aggregation period. This specifies the period during which an aggregation profile collects posted
         *        agent profiles for a profiling group. There are 3 valid values. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>P1D</code> — 1 day
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PT1H</code> — 1 hour
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PT5M</code> — 5 minutes
         *        </p>
         *        </li>
         * @see AggregationPeriod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AggregationPeriod
         */
        Builder period(String period);

        /**
         * <p>
         * The aggregation period. This specifies the period during which an aggregation profile collects posted agent
         * profiles for a profiling group. There are 3 valid values.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>P1D</code> — 1 day
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PT1H</code> — 1 hour
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PT5M</code> — 5 minutes
         * </p>
         * </li>
         * </ul>
         * 
         * @param period
         *        The aggregation period. This specifies the period during which an aggregation profile collects posted
         *        agent profiles for a profiling group. There are 3 valid values. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>P1D</code> — 1 day
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PT1H</code> — 1 hour
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PT5M</code> — 5 minutes
         *        </p>
         *        </li>
         * @see AggregationPeriod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AggregationPeriod
         */
        Builder period(AggregationPeriod period);

        /**
         * <p>
         * The name of the profiling group.
         * </p>
         * 
         * @param profilingGroupName
         *        The name of the profiling group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profilingGroupName(String profilingGroupName);

        /**
         * <p>
         * The start time of the time range from which to list the profiles.
         * </p>
         * 
         * @param startTime
         *        The start time of the time range from which to list the profiles.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodeGuruProfilerRequest.BuilderImpl implements Builder {
        private Instant endTime;

        private Integer maxResults;

        private String nextToken;

        private String orderBy;

        private String period;

        private String profilingGroupName;

        private Instant startTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ListProfileTimesRequest model) {
            super(model);
            endTime(model.endTime);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            orderBy(model.orderBy);
            period(model.period);
            profilingGroupName(model.profilingGroupName);
            startTime(model.startTime);
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getOrderBy() {
            return orderBy;
        }

        public final void setOrderBy(String orderBy) {
            this.orderBy = orderBy;
        }

        @Override
        public final Builder orderBy(String orderBy) {
            this.orderBy = orderBy;
            return this;
        }

        @Override
        public final Builder orderBy(OrderBy orderBy) {
            this.orderBy(orderBy == null ? null : orderBy.toString());
            return this;
        }

        public final String getPeriod() {
            return period;
        }

        public final void setPeriod(String period) {
            this.period = period;
        }

        @Override
        public final Builder period(String period) {
            this.period = period;
            return this;
        }

        @Override
        public final Builder period(AggregationPeriod period) {
            this.period(period == null ? null : period.toString());
            return this;
        }

        public final String getProfilingGroupName() {
            return profilingGroupName;
        }

        public final void setProfilingGroupName(String profilingGroupName) {
            this.profilingGroupName = profilingGroupName;
        }

        @Override
        public final Builder profilingGroupName(String profilingGroupName) {
            this.profilingGroupName = profilingGroupName;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListProfileTimesRequest build() {
            return new ListProfileTimesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
