/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codeguruprofiler.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The structure representing the GetRecommendationsRequest.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetRecommendationsRequest extends CodeGuruProfilerRequest implements
        ToCopyableBuilder<GetRecommendationsRequest.Builder, GetRecommendationsRequest> {
    private static final SdkField<Instant> END_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("endTime")
            .getter(getter(GetRecommendationsRequest::endTime))
            .setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("endTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> LOCALE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("locale")
            .getter(getter(GetRecommendationsRequest::locale)).setter(setter(Builder::locale))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("locale").build()).build();

    private static final SdkField<String> PROFILING_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("profilingGroupName").getter(getter(GetRecommendationsRequest::profilingGroupName))
            .setter(setter(Builder::profilingGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("profilingGroupName").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("startTime")
            .getter(getter(GetRecommendationsRequest::startTime))
            .setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("startTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(END_TIME_FIELD, LOCALE_FIELD,
            PROFILING_GROUP_NAME_FIELD, START_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Instant endTime;

    private final String locale;

    private final String profilingGroupName;

    private final Instant startTime;

    private GetRecommendationsRequest(BuilderImpl builder) {
        super(builder);
        this.endTime = builder.endTime;
        this.locale = builder.locale;
        this.profilingGroupName = builder.profilingGroupName;
        this.startTime = builder.startTime;
    }

    /**
     * <p>
     * The start time of the profile to get analysis data about. You must specify <code>startTime</code> and
     * <code>endTime</code>. This is specified using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z
     * represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
     * </p>
     * 
     * @return The start time of the profile to get analysis data about. You must specify <code>startTime</code> and
     *         <code>endTime</code>. This is specified using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z
     *         represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * The language used to provide analysis. Specify using a string that is one of the following <code>BCP 47</code>
     * language codes.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>de-DE</code> - German, Germany
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>en-GB</code> - English, United Kingdom
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>en-US</code> - English, United States
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>es-ES</code> - Spanish, Spain
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>fr-FR</code> - French, France
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>it-IT</code> - Italian, Italy
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ja-JP</code> - Japanese, Japan
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ko-KR</code> - Korean, Republic of Korea
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>pt-BR</code> - Portugese, Brazil
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>zh-CN</code> - Chinese, China
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>zh-TW</code> - Chinese, Taiwan
     * </p>
     * </li>
     * </ul>
     * 
     * @return The language used to provide analysis. Specify using a string that is one of the following
     *         <code>BCP 47</code> language codes. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>de-DE</code> - German, Germany
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>en-GB</code> - English, United Kingdom
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>en-US</code> - English, United States
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>es-ES</code> - Spanish, Spain
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>fr-FR</code> - French, France
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>it-IT</code> - Italian, Italy
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ja-JP</code> - Japanese, Japan
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ko-KR</code> - Korean, Republic of Korea
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>pt-BR</code> - Portugese, Brazil
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>zh-CN</code> - Chinese, China
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>zh-TW</code> - Chinese, Taiwan
     *         </p>
     *         </li>
     */
    public final String locale() {
        return locale;
    }

    /**
     * <p>
     * The name of the profiling group to get analysis data about.
     * </p>
     * 
     * @return The name of the profiling group to get analysis data about.
     */
    public final String profilingGroupName() {
        return profilingGroupName;
    }

    /**
     * <p>
     * The end time of the profile to get analysis data about. You must specify <code>startTime</code> and
     * <code>endTime</code>. This is specified using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z
     * represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
     * </p>
     * 
     * @return The end time of the profile to get analysis data about. You must specify <code>startTime</code> and
     *         <code>endTime</code>. This is specified using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z
     *         represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
     */
    public final Instant startTime() {
        return startTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(locale());
        hashCode = 31 * hashCode + Objects.hashCode(profilingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRecommendationsRequest)) {
            return false;
        }
        GetRecommendationsRequest other = (GetRecommendationsRequest) obj;
        return Objects.equals(endTime(), other.endTime()) && Objects.equals(locale(), other.locale())
                && Objects.equals(profilingGroupName(), other.profilingGroupName())
                && Objects.equals(startTime(), other.startTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetRecommendationsRequest").add("EndTime", endTime()).add("Locale", locale())
                .add("ProfilingGroupName", profilingGroupName()).add("StartTime", startTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "endTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "locale":
            return Optional.ofNullable(clazz.cast(locale()));
        case "profilingGroupName":
            return Optional.ofNullable(clazz.cast(profilingGroupName()));
        case "startTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("endTime", END_TIME_FIELD);
        map.put("locale", LOCALE_FIELD);
        map.put("profilingGroupName", PROFILING_GROUP_NAME_FIELD);
        map.put("startTime", START_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetRecommendationsRequest, T> g) {
        return obj -> g.apply((GetRecommendationsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CodeGuruProfilerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetRecommendationsRequest> {
        /**
         * <p>
         * The start time of the profile to get analysis data about. You must specify <code>startTime</code> and
         * <code>endTime</code>. This is specified using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z
         * represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
         * </p>
         * 
         * @param endTime
         *        The start time of the profile to get analysis data about. You must specify <code>startTime</code> and
         *        <code>endTime</code>. This is specified using the ISO 8601 format. For example,
         *        2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * The language used to provide analysis. Specify using a string that is one of the following
         * <code>BCP 47</code> language codes.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>de-DE</code> - German, Germany
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>en-GB</code> - English, United Kingdom
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>en-US</code> - English, United States
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>es-ES</code> - Spanish, Spain
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>fr-FR</code> - French, France
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>it-IT</code> - Italian, Italy
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ja-JP</code> - Japanese, Japan
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ko-KR</code> - Korean, Republic of Korea
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>pt-BR</code> - Portugese, Brazil
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>zh-CN</code> - Chinese, China
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>zh-TW</code> - Chinese, Taiwan
         * </p>
         * </li>
         * </ul>
         * 
         * @param locale
         *        The language used to provide analysis. Specify using a string that is one of the following
         *        <code>BCP 47</code> language codes. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>de-DE</code> - German, Germany
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>en-GB</code> - English, United Kingdom
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>en-US</code> - English, United States
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>es-ES</code> - Spanish, Spain
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>fr-FR</code> - French, France
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>it-IT</code> - Italian, Italy
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ja-JP</code> - Japanese, Japan
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ko-KR</code> - Korean, Republic of Korea
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>pt-BR</code> - Portugese, Brazil
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>zh-CN</code> - Chinese, China
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>zh-TW</code> - Chinese, Taiwan
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder locale(String locale);

        /**
         * <p>
         * The name of the profiling group to get analysis data about.
         * </p>
         * 
         * @param profilingGroupName
         *        The name of the profiling group to get analysis data about.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profilingGroupName(String profilingGroupName);

        /**
         * <p>
         * The end time of the profile to get analysis data about. You must specify <code>startTime</code> and
         * <code>endTime</code>. This is specified using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z
         * represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
         * </p>
         * 
         * @param startTime
         *        The end time of the profile to get analysis data about. You must specify <code>startTime</code> and
         *        <code>endTime</code>. This is specified using the ISO 8601 format. For example,
         *        2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodeGuruProfilerRequest.BuilderImpl implements Builder {
        private Instant endTime;

        private String locale;

        private String profilingGroupName;

        private Instant startTime;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRecommendationsRequest model) {
            super(model);
            endTime(model.endTime);
            locale(model.locale);
            profilingGroupName(model.profilingGroupName);
            startTime(model.startTime);
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getLocale() {
            return locale;
        }

        public final void setLocale(String locale) {
            this.locale = locale;
        }

        @Override
        public final Builder locale(String locale) {
            this.locale = locale;
            return this;
        }

        public final String getProfilingGroupName() {
            return profilingGroupName;
        }

        public final void setProfilingGroupName(String profilingGroupName) {
            this.profilingGroupName = profilingGroupName;
        }

        @Override
        public final Builder profilingGroupName(String profilingGroupName) {
            this.profilingGroupName = profilingGroupName;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetRecommendationsRequest build() {
            return new GetRecommendationsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
