/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codeguruprofiler.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codeguruprofiler.model.AnomalyInstance;
import software.amazon.awssdk.services.codeguruprofiler.model.AnomalyInstancesCopier;
import software.amazon.awssdk.services.codeguruprofiler.model.Metric;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Anomaly
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Anomaly> {
    private static final SdkField<List<AnomalyInstance>> INSTANCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("instances").getter(Anomaly.getter(Anomaly::instances)).setter(Anomaly.setter(Builder::instances)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instances").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AnomalyInstance::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Metric> METRIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("metric").getter(Anomaly.getter(Anomaly::metric)).setter(Anomaly.setter(Builder::metric)).constructor(Metric::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metric").build()}).build();
    private static final SdkField<String> REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("reason").getter(Anomaly.getter(Anomaly::reason)).setter(Anomaly.setter(Builder::reason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reason").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCES_FIELD, METRIC_FIELD, REASON_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Anomaly.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<AnomalyInstance> instances;
    private final Metric metric;
    private final String reason;

    private Anomaly(BuilderImpl builder) {
        this.instances = builder.instances;
        this.metric = builder.metric;
        this.reason = builder.reason;
    }

    public final boolean hasInstances() {
        return this.instances != null && !(this.instances instanceof SdkAutoConstructList);
    }

    public final List<AnomalyInstance> instances() {
        return this.instances;
    }

    public final Metric metric() {
        return this.metric;
    }

    public final String reason() {
        return this.reason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInstances() ? this.instances() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.metric());
        hashCode = 31 * hashCode + Objects.hashCode(this.reason());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Anomaly)) {
            return false;
        }
        Anomaly other = (Anomaly)obj;
        return this.hasInstances() == other.hasInstances() && Objects.equals(this.instances(), other.instances()) && Objects.equals(this.metric(), other.metric()) && Objects.equals(this.reason(), other.reason());
    }

    public final String toString() {
        return ToString.builder((String)"Anomaly").add("Instances", this.hasInstances() ? this.instances() : null).add("Metric", (Object)this.metric()).add("Reason", (Object)this.reason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "instances": {
                return Optional.ofNullable(clazz.cast(this.instances()));
            }
            case "metric": {
                return Optional.ofNullable(clazz.cast(this.metric()));
            }
            case "reason": {
                return Optional.ofNullable(clazz.cast(this.reason()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("instances", INSTANCES_FIELD);
        map.put("metric", METRIC_FIELD);
        map.put("reason", REASON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Anomaly, T> g) {
        return obj -> g.apply((Anomaly)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<AnomalyInstance> instances = DefaultSdkAutoConstructList.getInstance();
        private Metric metric;
        private String reason;

        private BuilderImpl() {
        }

        private BuilderImpl(Anomaly model) {
            this.instances(model.instances);
            this.metric(model.metric);
            this.reason(model.reason);
        }

        public final List<AnomalyInstance.Builder> getInstances() {
            List<AnomalyInstance.Builder> result = AnomalyInstancesCopier.copyToBuilder(this.instances);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInstances(Collection<AnomalyInstance.BuilderImpl> instances) {
            this.instances = AnomalyInstancesCopier.copyFromBuilder(instances);
        }

        @Override
        public final Builder instances(Collection<AnomalyInstance> instances) {
            this.instances = AnomalyInstancesCopier.copy(instances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instances(AnomalyInstance ... instances) {
            this.instances(Arrays.asList(instances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instances(Consumer<AnomalyInstance.Builder> ... instances) {
            this.instances(Stream.of(instances).map(c -> (AnomalyInstance)((AnomalyInstance.Builder)AnomalyInstance.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Metric.Builder getMetric() {
            return this.metric != null ? this.metric.toBuilder() : null;
        }

        public final void setMetric(Metric.BuilderImpl metric) {
            this.metric = metric != null ? metric.build() : null;
        }

        @Override
        public final Builder metric(Metric metric) {
            this.metric = metric;
            return this;
        }

        public final String getReason() {
            return this.reason;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        public Anomaly build() {
            return new Anomaly(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Anomaly> {
        public Builder instances(Collection<AnomalyInstance> var1);

        public Builder instances(AnomalyInstance ... var1);

        public Builder instances(Consumer<AnomalyInstance.Builder> ... var1);

        public Builder metric(Metric var1);

        default public Builder metric(Consumer<Metric.Builder> metric) {
            return this.metric((Metric)((Metric.Builder)Metric.builder().applyMutation(metric)).build());
        }

        public Builder reason(String var1);
    }
}

